/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class Transport
implements PlainJsonSerializable {
    private final long rxCount;
    private final long rxSizeInBytes;
    private final int serverOpen;
    private final long txCount;
    private final long txSizeInBytes;
    public static final JsonpDeserializer<Transport> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Transport::setupTransportDeserializer);

    private Transport(Builder builder) {
        this.rxCount = ApiTypeHelper.requireNonNull(builder.rxCount, this, "rxCount");
        this.rxSizeInBytes = ApiTypeHelper.requireNonNull(builder.rxSizeInBytes, this, "rxSizeInBytes");
        this.serverOpen = ApiTypeHelper.requireNonNull(builder.serverOpen, this, "serverOpen");
        this.txCount = ApiTypeHelper.requireNonNull(builder.txCount, this, "txCount");
        this.txSizeInBytes = ApiTypeHelper.requireNonNull(builder.txSizeInBytes, this, "txSizeInBytes");
    }

    public static Transport of(Function<Builder, ObjectBuilder<Transport>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long rxCount() {
        return this.rxCount;
    }

    public final long rxSizeInBytes() {
        return this.rxSizeInBytes;
    }

    public final int serverOpen() {
        return this.serverOpen;
    }

    public final long txCount() {
        return this.txCount;
    }

    public final long txSizeInBytes() {
        return this.txSizeInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("rx_count");
        generator.write(this.rxCount);
        generator.writeKey("rx_size_in_bytes");
        generator.write(this.rxSizeInBytes);
        generator.writeKey("server_open");
        generator.write(this.serverOpen);
        generator.writeKey("tx_count");
        generator.write(this.txCount);
        generator.writeKey("tx_size_in_bytes");
        generator.write(this.txSizeInBytes);
    }

    protected static void setupTransportDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::rxCount, JsonpDeserializer.longDeserializer(), "rx_count");
        op.add(Builder::rxSizeInBytes, JsonpDeserializer.longDeserializer(), "rx_size_in_bytes");
        op.add(Builder::serverOpen, JsonpDeserializer.integerDeserializer(), "server_open");
        op.add(Builder::txCount, JsonpDeserializer.longDeserializer(), "tx_count");
        op.add(Builder::txSizeInBytes, JsonpDeserializer.longDeserializer(), "tx_size_in_bytes");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Transport> {
        private Long rxCount;
        private Long rxSizeInBytes;
        private Integer serverOpen;
        private Long txCount;
        private Long txSizeInBytes;

        public final Builder rxCount(long value) {
            this.rxCount = value;
            return this;
        }

        public final Builder rxSizeInBytes(long value) {
            this.rxSizeInBytes = value;
            return this;
        }

        public final Builder serverOpen(int value) {
            this.serverOpen = value;
            return this;
        }

        public final Builder txCount(long value) {
            this.txCount = value;
            return this;
        }

        public final Builder txSizeInBytes(long value) {
            this.txSizeInBytes = value;
            return this;
        }

        @Override
        public Transport build() {
            this._checkSingleUse();
            return new Transport(this);
        }
    }
}

