/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cat;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.util.ObjectBuilder;

public abstract class CatRequestBase
extends RequestBase {
    @Nullable
    private final String headers;
    @Nullable
    private final String sort;

    public CatRequestBase() {
        this.headers = null;
        this.sort = null;
    }

    protected CatRequestBase(AbstractBuilder<?> builder) {
        super(builder);
        this.headers = builder.headers;
        this.sort = builder.sort;
    }

    @Nullable
    public final String headers() {
        return this.headers;
    }

    @Nullable
    public final String sort() {
        return this.sort;
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.headers != null && !this.headers.trim().isEmpty()) {
            params.put("h", this.headers);
        }
        if (this.sort != null && !this.sort.trim().isEmpty()) {
            params.put("s", this.sort);
        }
        params.put("format", "json");
    }

    protected final Map<String, String> queryParameters() {
        HashMap<String, String> params = new HashMap<String, String>();
        this.applyQueryParameters(params);
        return params;
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends RequestBase.AbstractBuilder<BuilderT> {
        @Nullable
        protected String headers;
        @Nullable
        protected String sort;

        protected AbstractBuilder() {
        }

        protected AbstractBuilder(CatRequestBase o) {
            super(o);
            this.headers = o.headers;
            this.sort = o.sort;
        }

        protected AbstractBuilder(AbstractBuilder<BuilderT> o) {
            super(o);
            this.headers = o.headers;
            this.sort = o.sort;
        }

        @Nonnull
        public final BuilderT headers(@Nullable String headers) {
            this.headers = headers;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        @Nonnull
        public final BuilderT sort(@Nullable String sort) {
            this.sort = sort;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }

    protected static abstract class CatRequestBaseBuilder<BuilderT extends CatRequestBaseBuilder<BuilderT>>
    extends AbstractBuilder<BuilderT>
    implements ObjectBuilder {
        protected CatRequestBaseBuilder() {
        }
    }
}

