/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.opensearch._types.query_dsl.SpanQuery;
import org.opensearch.client.opensearch._types.query_dsl.SpanQueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class SpanOrQuery
extends QueryBase
implements SpanQueryVariant,
QueryVariant {
    private final List<SpanQuery> clauses;
    public static final JsonpDeserializer<SpanOrQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SpanOrQuery::setupSpanOrQueryDeserializer);

    private SpanOrQuery(Builder builder) {
        super(builder);
        this.clauses = ApiTypeHelper.unmodifiableRequired(builder.clauses, (Object)this, "clauses");
    }

    public static SpanOrQuery of(Function<Builder, ObjectBuilder<SpanOrQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public SpanQuery.Kind _spanQueryKind() {
        return SpanQuery.Kind.SpanOr;
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.SpanOr;
    }

    public final List<SpanQuery> clauses() {
        return this.clauses;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.clauses)) {
            generator.writeKey("clauses");
            generator.writeStartArray();
            for (SpanQuery item0 : this.clauses) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public Builder toBuilder() {
        return this.toBuilder(new Builder()).clauses(this.clauses);
    }

    protected static void setupSpanOrQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::clauses, JsonpDeserializer.arrayDeserializer(SpanQuery._DESERIALIZER), "clauses");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SpanOrQuery> {
        private List<SpanQuery> clauses;

        public final Builder clauses(List<SpanQuery> list) {
            this.clauses = Builder._listAddAll(this.clauses, list);
            return this;
        }

        public final Builder clauses(SpanQuery value, SpanQuery ... values) {
            this.clauses = Builder._listAdd(this.clauses, value, values);
            return this;
        }

        public final Builder clauses(Function<SpanQuery.Builder, ObjectBuilder<SpanQuery>> fn) {
            return this.clauses(fn.apply(new SpanQuery.Builder()).build(), new SpanQuery[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SpanOrQuery build() {
            this._checkSingleUse();
            return new SpanOrQuery(this);
        }
    }
}

