/*
 * Decompiled with CFR 0.152.
 */
package org.awaitility.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.awaitility.reflect.AssignableToFieldTypeMatcherStrategy;
import org.awaitility.reflect.FieldAnnotationMatcherStrategy;
import org.awaitility.reflect.FieldMatcherStrategy;
import org.awaitility.reflect.FieldNameAndTypeMatcherStrategy;
import org.awaitility.reflect.FieldNameMatcherStrategy;
import org.awaitility.reflect.exception.FieldNotFoundException;
import org.awaitility.reflect.exception.TooManyFieldsFoundException;

public class WhiteboxImpl {
    public static <T> T getInternalState(Object object, String fieldName) {
        Field foundField = WhiteboxImpl.findFieldInHierarchy(object, fieldName);
        try {
            return (T)foundField.get(object);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Internal error: Failed to get field in method getInternalState.", e);
        }
    }

    private static Field findFieldInHierarchy(Object object, String fieldName) {
        return WhiteboxImpl.findFieldInHierarchy(object, new FieldNameMatcherStrategy(fieldName));
    }

    private static Field findFieldInHierarchy(Object object, FieldMatcherStrategy strategy) {
        WhiteboxImpl.assertObjectInGetInternalStateIsNotNull(object);
        return WhiteboxImpl.findSingleFieldUsingStrategy(strategy, object, true, WhiteboxImpl.getType(object));
    }

    private static void assertObjectInGetInternalStateIsNotNull(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("The object containing the field cannot be null");
        }
    }

    private static Field findSingleFieldUsingStrategy(FieldMatcherStrategy strategy, Object object, boolean checkHierarchy, Class<?> startClass) {
        WhiteboxImpl.assertObjectInGetInternalStateIsNotNull(object);
        Field foundField = null;
        Class<?> originalStartClass = startClass;
        while (startClass != null) {
            Field[] declaredFields;
            for (Field field : declaredFields = startClass.getDeclaredFields()) {
                if (!strategy.matches(field) || !WhiteboxImpl.hasFieldProperModifier(object, field)) continue;
                if (foundField != null) {
                    throw new TooManyFieldsFoundException("Two or more fields matching " + strategy + ".");
                }
                foundField = field;
            }
            if (foundField != null || !checkHierarchy) break;
            startClass = startClass.getSuperclass();
        }
        if (foundField == null) {
            strategy.notFound(originalStartClass, !WhiteboxImpl.isClass(object));
            return null;
        }
        foundField.setAccessible(true);
        return foundField;
    }

    private static boolean hasFieldProperModifier(Object object, Field field) {
        return object instanceof Class && Modifier.isStatic(field.getModifiers()) || !(object instanceof Class) && !Modifier.isStatic(field.getModifiers());
    }

    public static <T> T getInternalState(Object object, Class<T> fieldType) {
        Field foundField = WhiteboxImpl.findFieldInHierarchy(object, new AssignableToFieldTypeMatcherStrategy(fieldType));
        try {
            return (T)foundField.get(object);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Internal error: Failed to get field in method getInternalState.", e);
        }
    }

    public static void throwExceptionIfFieldWasNotFound(Class<?> type, String fieldName, Field field) {
        if (field == null) {
            throw new FieldNotFoundException("No field was found with name '" + fieldName + "' in class " + type.getName() + ".");
        }
    }

    public static Class<?> getType(Object object) {
        Class<?> type = null;
        if (WhiteboxImpl.isClass(object)) {
            type = (Class<?>)object;
        } else if (object != null) {
            type = object.getClass();
        }
        return type;
    }

    public static Field getFieldAnnotatedWith(Object object, Class<? extends Annotation> annotationType) {
        return WhiteboxImpl.findSingleFieldUsingStrategy(new FieldAnnotationMatcherStrategy(annotationType), object, true, WhiteboxImpl.getType(object));
    }

    public static boolean isClass(Object argument) {
        return argument instanceof Class;
    }

    public static <T> T getByNameAndType(Object object, String fieldName, Class<T> expectedFieldType) {
        Field foundField = WhiteboxImpl.findSingleFieldUsingStrategy(new FieldNameAndTypeMatcherStrategy(fieldName, expectedFieldType), object, true, WhiteboxImpl.getType(object));
        try {
            return (T)foundField.get(object);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Internal error: Failed to get field in method getInternalState.", e);
        }
    }
}

