/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing;

import io.micrometer.common.lang.Nullable;
import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.Tracer;
import java.io.Closeable;

public class SpanAndScope
implements Closeable {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(SpanAndScope.class);
    private final Span span;
    private final Tracer.SpanInScope scope;

    public SpanAndScope(Span span, @Nullable Tracer.SpanInScope scope) {
        this.span = span;
        this.scope = scope;
    }

    public Span getSpan() {
        return this.span;
    }

    @Nullable
    public Tracer.SpanInScope getScope() {
        return this.scope;
    }

    public String toString() {
        return "SpanAndScope{span=" + this.span + '}';
    }

    @Override
    public void close() {
        if (log.isTraceEnabled()) {
            log.trace("Closing span [" + this.span + "]");
        }
        if (this.scope != null) {
            this.scope.close();
        }
        this.span.end();
    }
}

