/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.protocols;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import java.security.Provider;
import java.security.Security;
import org.apache.james.jmap.JMAPConfiguration;
import org.apache.james.jmap.JMAPServer;
import org.apache.james.jmap.JmapGuiceProbe;
import org.apache.james.jmap.MessageIdProbe;
import org.apache.james.utils.GuiceProbe;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class JMAPServerModule
extends AbstractModule {
    protected void configure() {
        Multibinder.newSetBinder((Binder)this.binder(), GuiceProbe.class).addBinding().to(JmapGuiceProbe.class);
        Multibinder.newSetBinder((Binder)this.binder(), GuiceProbe.class).addBinding().to(MessageIdProbe.class);
    }

    @ProvidesIntoSet
    InitializationOperation startJmap(JMAPServer server, JMAPConfiguration jmapConfiguration) {
        return InitilizationOperationBuilder.forClass(JMAPServer.class).init(() -> {
            if (jmapConfiguration.isEnabled()) {
                server.start();
                this.registerPEMWithSecurityProvider();
            }
        });
    }

    private void registerPEMWithSecurityProvider() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

