/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.jooq.Commit;
import org.jooq.Commits;
import org.jooq.Configuration;
import org.jooq.ContentType;
import org.jooq.File;
import org.jooq.FilePattern;
import org.jooq.Migrations;
import org.jooq.Source;
import org.jooq.Tag;
import org.jooq.conf.MigrationDefaultContentType;
import org.jooq.exception.DataMigrationVerificationException;
import org.jooq.impl.CommitImpl;
import org.jooq.impl.MigrationImpl;
import org.jooq.impl.TagImpl;
import org.jooq.impl.Tools;
import org.jooq.migrations.xml.jaxb.ChangeType;
import org.jooq.migrations.xml.jaxb.CommitType;
import org.jooq.migrations.xml.jaxb.FileType;
import org.jooq.migrations.xml.jaxb.MigrationsType;
import org.jooq.migrations.xml.jaxb.ParentType;
import org.jooq.migrations.xml.jaxb.TagType;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;
import org.jooq.util.jaxb.tools.MiniJAXB;

final class CommitsImpl
implements Commits {
    private static final JooqLogger log = JooqLogger.getLogger(CommitsImpl.class);
    final Configuration configuration;
    final Migrations migrations;
    final Commit root;
    final Map<String, Commit> commitsById;
    final Map<String, Commit> commitsByTag;

    CommitsImpl(Configuration configuration, Commit root) {
        this.configuration = configuration;
        this.migrations = configuration.dsl().migrations();
        this.commitsById = new LinkedHashMap<String, Commit>();
        this.commitsByTag = new LinkedHashMap<String, Commit>();
        this.root = root;
        this.add(root);
    }

    @Override
    public final Commits add(Commit commit) {
        if (this.root != commit.root()) {
            throw new DataMigrationVerificationException("A Commits graph must contain a single graph whose commits all share the same root.");
        }
        Commit duplicate = this.commitsById.get(commit.id());
        if (duplicate != null) {
            throw new DataMigrationVerificationException("Duplicate commit ID already present on commit: " + String.valueOf(duplicate));
        }
        for (Tag tag : commit.tags()) {
            duplicate = this.commitsByTag.get(tag.id());
            if (duplicate == null) continue;
            throw new DataMigrationVerificationException("Duplicate tag " + String.valueOf(tag) + " already present on commit: " + String.valueOf(duplicate));
        }
        this.commitsById.put(commit.id(), commit);
        for (Tag tag : commit.tags()) {
            this.commitsByTag.put(tag.id(), commit);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Commit added", commit);
        }
        return this;
    }

    @Override
    public final Commits addAll(Commit ... c) {
        return this.addAll(Arrays.asList(c));
    }

    @Override
    public final Commits addAll(Collection<? extends Commit> c) {
        for (Commit commit : c) {
            this.add(commit);
        }
        return this;
    }

    @Override
    public final Commit root() {
        return this.root;
    }

    @Override
    public final Commit current() {
        return new MigrationImpl(this.configuration, this.root).currentCommit(false);
    }

    @Override
    public final Commit latest() {
        HashMap<String, Commit> commits = new HashMap<String, Commit>(this.commitsById);
        for (Map.Entry<String, Commit> e : this.commitsById.entrySet()) {
            for (Commit parent : e.getValue().parents()) {
                commits.remove(parent.id());
            }
        }
        if (commits.size() == 1) {
            return (Commit)commits.values().iterator().next();
        }
        throw new DataMigrationVerificationException("No latest commit available. There are " + commits.size() + " unmerged branches.");
    }

    @Override
    public final Commit get(String id) {
        Commit result = this.commitsById.get(id);
        return result != null ? result : this.commitsByTag.get(id);
    }

    @Override
    public final Iterator<Commit> iterator() {
        return Collections.unmodifiableCollection(this.commitsById.values()).iterator();
    }

    static final ContentType contentType(String name) {
        switch (name.toLowerCase()) {
            case "schemas": {
                return ContentType.SCHEMA;
            }
            case "scripts": {
                return ContentType.SCRIPT;
            }
            case "increments": {
                return ContentType.INCREMENT;
            }
            case "snapshots": {
                return ContentType.SNAPSHOT;
            }
        }
        throw new IllegalArgumentException("Unsupported content type: " + name);
    }

    @Override
    public final Commits load(java.io.File directory) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Reading directory", directory);
        }
        FilePattern sqlPattern = new FilePattern().basedir(directory).pattern("**.sql");
        FilePattern xmlPattern = new FilePattern().basedir(directory).pattern("**.xml");
        List<Source> sql = sqlPattern.collect();
        if (!Tools.isEmpty(sql)) {
            return this.loadSQL(sqlPattern, sql);
        }
        List<Source> xml = xmlPattern.collect();
        if (!Tools.isEmpty(xml)) {
            return this.loadXML(xmlPattern, xml);
        }
        return this;
    }

    private final Commits loadSQL(FilePattern pattern, List<Source> files) throws IOException {
        TreeMap<String, CommitType> idToCommit = new TreeMap<String, CommitType>(Comparator.comparing(java.io.File::new, pattern.fileComparator()));
        List<FileData> list = files.stream().map(s -> new FileData(pattern, (Source)s)).collect(Collectors.toList());
        if (log.isDebugEnabled()) {
            list.forEach(f -> log.debug((Object)"Reading file", f));
        }
        for (FileData f2 : list) {
            idToCommit.putIfAbsent(f2.id, new CommitType().withId(f2.id).withAuthor(f2.author).withMessage(f2.message).withTags(f2.tags));
        }
        for (FileData f2 : list) {
            CommitType commit = (CommitType)idToCommit.get(f2.id);
            if (f2.parents.isEmpty()) {
                Map.Entry e = idToCommit.lowerEntry(f2.id);
                if (e != null) {
                    commit.setParents(Arrays.asList(new ParentType().withId(e.getKey())));
                }
            } else {
                for (String parent : f2.parents) {
                    if (idToCommit.containsKey(parent)) {
                        commit.getParents().add(new ParentType().withId(parent));
                        continue;
                    }
                    throw new DataMigrationVerificationException("Parent " + parent + " is not defined");
                }
            }
            commit.getFiles().add(new FileType().withPath(f2.path).withContentType(f2.contentType).withContent(f2.source.readString()).withChange(ChangeType.MODIFY));
        }
        if (log.isDebugEnabled()) {
            log.debug("Loading files into: " + String.valueOf(new MigrationsType().withCommits(idToCommit.values())));
        }
        return this.load(new MigrationsType().withCommits(idToCommit.values()));
    }

    private final Commits loadXML(FilePattern pattern, List<Source> files) throws IOException {
        MigrationsType m = new MigrationsType();
        for (Source s : files) {
            Reader reader = s.reader();
            try {
                MigrationsType u = MiniJAXB.unmarshal(s.reader(), MigrationsType.class);
                m = MiniJAXB.append(m, u);
            }
            finally {
                if (reader == null) continue;
                reader.close();
            }
        }
        return this.load(m);
    }

    @Override
    public final Commits load(MigrationsType migrations) {
        HashMap<String, CommitType> map = new HashMap<String, CommitType>();
        for (CommitType commit : migrations.getCommits()) {
            map.put(commit.getId(), commit);
        }
        map.putIfAbsent("root", new CommitType().withId(this.root.id()).withMessage(this.root.message()));
        for (CommitType commit : migrations.getCommits()) {
            this.load(map, commit);
        }
        return this;
    }

    private final Commit load(Map<String, CommitType> map, CommitType commit) {
        Commit result = this.commitsById.get(commit.getId());
        if (result != null) {
            if (result.equals(this.root)) {
                ((CommitImpl)result).delta.putAll(CommitImpl.map(this.files(commit), false));
                ((CommitImpl)result).files = null;
                ((CommitImpl)result).tags.addAll(Tools.map(commit.getTags(), t -> new TagImpl(t.getId(), t.getMessage())));
            }
            return result;
        }
        Commit p1 = this.root;
        Commit p2 = null;
        List<ParentType> parents = commit.getParents();
        int size = parents.size();
        if (size > 0) {
            CommitType c1 = map.get(parents.get(0).getId());
            if (c1 == null) {
                throw new DataMigrationVerificationException("Parent not found: " + parents.get(0).getId());
            }
            p1 = this.load(map, c1);
            if (size == 2) {
                CommitType c2 = map.get(parents.get(1).getId());
                if (c2 == null) {
                    throw new DataMigrationVerificationException("Parent not found: " + parents.get(0).getId());
                }
                p2 = this.load(map, c2);
            } else if (size > 2) {
                throw new DataMigrationVerificationException("Merging more than two parents not yet supported");
            }
        }
        result = p2 == null ? p1.commit(commit.getId(), commit.getMessage(), commit.getAuthor(), this.files(commit)) : p1.merge(commit.getId(), commit.getMessage(), commit.getAuthor(), p2, this.files(commit));
        for (TagType tag : commit.getTags()) {
            result = result.tag(tag.getId(), tag.getMessage());
        }
        this.add(result);
        return result;
    }

    private final List<File> files(CommitType commit) {
        return Tools.map(commit.getFiles(), f -> this.migrations.file(f.getPath(), f.getChange() == ChangeType.DELETE ? null : f.getContent(), f.getContentType()));
    }

    @Override
    public final MigrationsType export() {
        return new MigrationsType().withCommits(Tools.map(Tools.filter(this, c -> !"root".equals(c.id())), commit -> new CommitType().withId(commit.id()).withMessage(commit.message()).withAuthor(commit.author()).withParents(Tools.map(commit.parents(), parent -> new ParentType().withId(parent.id()))).withTags(Tools.map(commit.tags(), tag -> new TagType().withId(tag.id()).withMessage(tag.message()))).withFiles(Tools.map(commit.files(), file -> new FileType().withPath(file.path()).withContent(file.content()).withContentType(file.type()).withChange(file.content() == null ? ChangeType.DELETE : ChangeType.MODIFY)))));
    }

    public String toString() {
        return String.valueOf(this.commitsById.values());
    }

    final class FileData {
        final FilePattern pattern;
        final Source source;
        final String path;
        final String id;
        final String message;
        final String author;
        final List<TagType> tags;
        final List<String> parents;
        final ContentType contentType;

        FileData(FilePattern pattern, Source source) {
            this.pattern = pattern;
            this.source = source;
            String name = source.name();
            if (name == null) {
                throw new DataMigrationVerificationException("Cannot work with unnamed sources: " + String.valueOf(source));
            }
            String basename = name.replace(".sql", "");
            java.io.File p1 = new java.io.File(pattern.path(source.file())).getParentFile();
            java.io.File p2 = p1 != null ? p1.getParentFile() : null;
            this.contentType = p2 == null ? this.defaultContentType() : CommitsImpl.contentType(p1.getName());
            this.path = name;
            this.id = p1 == null ? basename : (p2 == null ? p1.getName() : p2.getName());
            java.io.File meta = new java.io.File(source.file().getParent(), basename + ".xml");
            CommitType commit = null;
            if (meta.exists()) {
                commit = MiniJAXB.unmarshal(meta, CommitType.class);
            }
            this.message = commit != null && commit.getMessage() != null ? commit.getMessage() : (p2 != null || p1 != null ? basename : null);
            this.author = commit != null ? commit.getAuthor() : null;
            this.tags = new ArrayList<TagType>();
            this.parents = new ArrayList<String>();
            if (commit != null) {
                for (TagType tag : commit.getTags()) {
                    this.tags.add(tag);
                }
                for (ParentType parent : commit.getParents()) {
                    this.parents.add(parent.getId());
                }
            }
        }

        private final ContentType defaultContentType() {
            switch (StringUtils.defaultIfNull(CommitsImpl.this.configuration.settings().getMigrationDefaultContentType(), MigrationDefaultContentType.INCREMENT)) {
                case INCREMENT: {
                    return ContentType.INCREMENT;
                }
                case SCRIPT: {
                    return ContentType.SCRIPT;
                }
            }
            throw new UnsupportedOperationException("Unsupported ContentType: " + String.valueOf((Object)CommitsImpl.this.configuration.settings().getMigrationDefaultContentType()));
        }

        public String toString() {
            ArrayList<CallSite> strings = new ArrayList<CallSite>();
            if (this.id != null) {
                strings.add((CallSite)((Object)("id: " + this.id)));
            }
            if (this.message != null) {
                strings.add((CallSite)((Object)("message: " + this.message)));
            }
            if (!this.tags.isEmpty()) {
                strings.add((CallSite)((Object)("tags: " + String.valueOf(this.tags))));
            }
            if (!this.parents.isEmpty()) {
                strings.add((CallSite)((Object)("parents: " + String.valueOf(this.parents))));
            }
            return "File: " + String.valueOf(this.source.file()) + " " + String.valueOf(strings);
        }
    }
}

