/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Objects;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeValue;

public class AttributeName {
    private final String name;

    public static AttributeName of(String name) {
        Preconditions.checkNotNull(name, "`name` is compulsory");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "`name` should not be empty");
        return new AttributeName(name);
    }

    private AttributeName(String name) {
        this.name = name;
    }

    public Attribute withValue(AttributeValue<?> value) {
        return new Attribute(this, value);
    }

    public String asString() {
        return this.name;
    }

    public final boolean equals(Object o) {
        if (o instanceof AttributeName) {
            AttributeName that = (AttributeName)o;
            return Objects.equals(this.name, that.name);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).toString();
    }
}

