/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.mailbox.model.CurrentQuotas;
import org.apache.james.mailbox.model.QuotaRoot;

public class QuotaOperation {
    private final QuotaRoot quotaRoot;
    private final QuotaCountUsage count;
    private final QuotaSizeUsage size;

    public static QuotaOperation from(QuotaRoot quotaRoot, CurrentQuotas currentQuotas) {
        return new QuotaOperation(quotaRoot, currentQuotas.count(), currentQuotas.size());
    }

    public QuotaOperation(QuotaRoot quotaRoot, QuotaCountUsage count, QuotaSizeUsage size) {
        Preconditions.checkArgument(count.asLong() >= 0L, "Count should be positive");
        Preconditions.checkArgument(size.asLong() >= 0L, "Size should be positive");
        this.quotaRoot = quotaRoot;
        this.count = count;
        this.size = size;
    }

    public QuotaRoot quotaRoot() {
        return this.quotaRoot;
    }

    public QuotaCountUsage count() {
        return this.count;
    }

    public QuotaSizeUsage size() {
        return this.size;
    }

    public final boolean equals(Object o) {
        if (o instanceof QuotaOperation) {
            QuotaOperation quotaOperation = (QuotaOperation)o;
            return Objects.equals(this.quotaRoot, quotaOperation.quotaRoot) && Objects.equals(this.count, quotaOperation.count) && Objects.equals(this.size, quotaOperation.size);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.quotaRoot, this.count, this.size);
    }
}

