/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core.quota;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaUsageValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuotaSizeUsage
implements QuotaUsageValue<QuotaSizeUsage, QuotaSizeLimit> {
    public static final QuotaSizeUsage ZERO = new QuotaSizeUsage(0L);
    private static final Logger LOGGER = LoggerFactory.getLogger(QuotaSizeUsage.class);
    private final long value;

    public static QuotaSizeUsage size(long value) {
        return new QuotaSizeUsage(value);
    }

    private QuotaSizeUsage(long value) {
        this.value = value;
    }

    @Override
    public long asLong() {
        return this.value;
    }

    @Override
    public QuotaSizeUsage add(long additionalValue) {
        return new QuotaSizeUsage(this.value + additionalValue);
    }

    @Override
    public QuotaSizeUsage add(QuotaSizeUsage additionalValue) {
        return new QuotaSizeUsage(this.value + additionalValue.asLong());
    }

    @Override
    public boolean exceedLimit(QuotaSizeLimit limit) {
        if (limit.isLimited()) {
            return this.value > limit.asLong();
        }
        return false;
    }

    public boolean isValid() {
        return this.value >= 0L;
    }

    public Sanitized sanitize() {
        if (!this.isValid()) {
            LOGGER.warn("Invalid quota count usage : {}", (Object)this.value);
        }
        return Sanitized.of(Math.max(this.value, 0L));
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("value", this.value).toString();
    }

    public final boolean equals(Object o) {
        if (o instanceof QuotaSizeUsage) {
            QuotaSizeUsage that = (QuotaSizeUsage)o;
            return Objects.equal(this.value, that.value);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode(this.value);
    }

    public static class Sanitized
    extends QuotaSizeUsage {
        private static Sanitized of(long value) {
            Preconditions.checkArgument(value >= 0L, "Sanitized quota shall be positive");
            return new Sanitized((Long)value);
        }

        private Sanitized(Long value) {
            super(value);
        }
    }
}

