/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.BlobMetadata;
import org.apache.iceberg.GenericBlobMetadata;
import org.apache.iceberg.GenericStatisticsFile;
import org.apache.iceberg.StatisticsFile;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.util.JsonUtil;

public class StatisticsFileParser {
    private static final String SNAPSHOT_ID = "snapshot-id";
    private static final String STATISTICS_PATH = "statistics-path";
    private static final String FILE_SIZE_IN_BYTES = "file-size-in-bytes";
    private static final String FILE_FOOTER_SIZE_IN_BYTES = "file-footer-size-in-bytes";
    private static final String BLOB_METADATA = "blob-metadata";
    private static final String TYPE = "type";
    private static final String SEQUENCE_NUMBER = "sequence-number";
    private static final String FIELDS = "fields";
    private static final String PROPERTIES = "properties";

    private StatisticsFileParser() {
    }

    public static String toJson(StatisticsFile statisticsFile) {
        return StatisticsFileParser.toJson(statisticsFile, false);
    }

    public static String toJson(StatisticsFile statisticsFile, boolean pretty) {
        return JsonUtil.generate(gen -> StatisticsFileParser.toJson(statisticsFile, gen), pretty);
    }

    public static void toJson(StatisticsFile statisticsFile, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeNumberField(SNAPSHOT_ID, statisticsFile.snapshotId());
        generator.writeStringField(STATISTICS_PATH, statisticsFile.path());
        generator.writeNumberField(FILE_SIZE_IN_BYTES, statisticsFile.fileSizeInBytes());
        generator.writeNumberField(FILE_FOOTER_SIZE_IN_BYTES, statisticsFile.fileFooterSizeInBytes());
        generator.writeArrayFieldStart(BLOB_METADATA);
        for (BlobMetadata blobMetadata : statisticsFile.blobMetadata()) {
            StatisticsFileParser.toJson(blobMetadata, generator);
        }
        generator.writeEndArray();
        generator.writeEndObject();
    }

    static StatisticsFile fromJson(JsonNode node) {
        long snapshotId = JsonUtil.getLong(SNAPSHOT_ID, node);
        String path = JsonUtil.getString(STATISTICS_PATH, node);
        long fileSizeInBytes = JsonUtil.getLong(FILE_SIZE_IN_BYTES, node);
        long fileFooterSizeInBytes = JsonUtil.getLong(FILE_FOOTER_SIZE_IN_BYTES, node);
        ImmutableList.Builder blobMetadata = ImmutableList.builder();
        JsonNode blobsJson = node.get(BLOB_METADATA);
        Preconditions.checkArgument((blobsJson != null && blobsJson.isArray() ? 1 : 0) != 0, (String)"Cannot parse blob metadata from non-array: %s", (Object)blobsJson);
        for (JsonNode blobJson : blobsJson) {
            blobMetadata.add((Object)StatisticsFileParser.blobMetadataFromJson(blobJson));
        }
        return new GenericStatisticsFile(snapshotId, path, fileSizeInBytes, fileFooterSizeInBytes, (List<BlobMetadata>)blobMetadata.build());
    }

    private static void toJson(BlobMetadata blobMetadata, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeStringField(TYPE, blobMetadata.type());
        generator.writeNumberField(SNAPSHOT_ID, blobMetadata.sourceSnapshotId());
        generator.writeNumberField(SEQUENCE_NUMBER, blobMetadata.sourceSnapshotSequenceNumber());
        generator.writeArrayFieldStart(FIELDS);
        Iterator iterator = blobMetadata.fields().iterator();
        while (iterator.hasNext()) {
            int field = (Integer)iterator.next();
            generator.writeNumber(field);
        }
        generator.writeEndArray();
        if (!blobMetadata.properties().isEmpty()) {
            JsonUtil.writeStringMap(PROPERTIES, blobMetadata.properties(), generator);
        }
        generator.writeEndObject();
    }

    private static BlobMetadata blobMetadataFromJson(JsonNode node) {
        String type = JsonUtil.getString(TYPE, node);
        long sourceSnapshotId = JsonUtil.getLong(SNAPSHOT_ID, node);
        long sourceSnapshotSequenceNumber = JsonUtil.getLong(SEQUENCE_NUMBER, node);
        List<Integer> fields = JsonUtil.getIntegerList(FIELDS, node);
        Object properties = node.has(PROPERTIES) ? JsonUtil.getStringMap(PROPERTIES, node) : ImmutableMap.of();
        return new GenericBlobMetadata(type, sourceSnapshotId, sourceSnapshotSequenceNumber, fields, (Map<String, String>)properties);
    }
}

