/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.storage.aws;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.polaris.core.storage.PolarisStorageConfigurationInfo;
import org.apache.polaris.core.storage.aws.ImmutableAwsStorageConfigurationInfo;
import org.apache.polaris.immutables.PolarisImmutable;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableAwsStorageConfigurationInfo.class)
@JsonDeserialize(as=ImmutableAwsStorageConfigurationInfo.class)
@JsonTypeName(value="AwsStorageConfigurationInfo")
@PolarisImmutable
public abstract class AwsStorageConfigurationInfo
extends PolarisStorageConfigurationInfo {
    @JsonIgnore
    public static final String ROLE_ARN_PATTERN = "^arn:(aws|aws-us-gov):iam::(\\d{12}):role/.+$";
    private static final Pattern ROLE_ARN_PATTERN_COMPILED = Pattern.compile("^arn:(aws|aws-us-gov):iam::(\\d{12}):role/.+$");

    public static ImmutableAwsStorageConfigurationInfo.Builder builder() {
        return ImmutableAwsStorageConfigurationInfo.builder();
    }

    @Override
    public PolarisStorageConfigurationInfo.StorageType getStorageType() {
        return PolarisStorageConfigurationInfo.StorageType.S3;
    }

    @Override
    public String getFileIoImplClassName() {
        return "org.apache.iceberg.aws.s3.S3FileIO";
    }

    @Nullable
    public abstract String getRoleARN();

    @Nullable
    public abstract String getExternalId();

    @Nullable
    public abstract String getUserARN();

    @Nullable
    public abstract String getRegion();

    @Nullable
    public abstract String getEndpoint();

    @Nullable
    public abstract String getEndpointInternal();

    @JsonIgnore
    @Nullable
    public URI getEndpointUri() {
        return this.getEndpoint() == null ? null : URI.create(this.getEndpoint());
    }

    @JsonIgnore
    @Nullable
    public URI getInternalEndpointUri() {
        return this.getEndpointInternal() == null ? this.getEndpointUri() : URI.create(this.getEndpointInternal());
    }

    @Nullable
    public abstract Boolean getPathStyleAccess();

    @Nullable
    public abstract Boolean getStsUnavailable();

    @Nullable
    public abstract String getStsEndpoint();

    @JsonIgnore
    @Nullable
    public URI getStsEndpointUri() {
        return this.getStsEndpoint() == null ? this.getInternalEndpointUri() : URI.create(this.getStsEndpoint());
    }

    @JsonIgnore
    @Nullable
    public String getAwsAccountId() {
        String arn = this.getRoleARN();
        if (arn != null) {
            Matcher matcher = ROLE_ARN_PATTERN_COMPILED.matcher(arn);
            Preconditions.checkState((boolean)matcher.matches());
            return matcher.group(2);
        }
        return null;
    }

    @JsonIgnore
    @Nullable
    public String getAwsPartition() {
        String arn = this.getRoleARN();
        if (arn != null) {
            Matcher matcher = ROLE_ARN_PATTERN_COMPILED.matcher(arn);
            Preconditions.checkState((boolean)matcher.matches());
            return matcher.group(1);
        }
        return null;
    }

    @Override
    @Value.Check
    protected void check() {
        Matcher matcher;
        super.check();
        String arn = this.getRoleARN();
        AwsStorageConfigurationInfo.validateArn(arn);
        if (arn != null && !(matcher = ROLE_ARN_PATTERN_COMPILED.matcher(arn)).matches()) {
            throw new IllegalArgumentException("ARN does not match the expected role ARN pattern");
        }
    }

    public static void validateArn(String arn) {
        if (arn == null) {
            return;
        }
        if (arn.isEmpty()) {
            throw new IllegalArgumentException("ARN must not be empty");
        }
        if (arn.contains("aws-cn")) {
            throw new IllegalArgumentException("AWS China is temporarily not supported");
        }
        Preconditions.checkArgument((boolean)Pattern.matches(ROLE_ARN_PATTERN, arn), (String)"Invalid role ARN format: %s", (Object)arn);
    }
}

