/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.security;

import io.quarkus.tls.TlsConfiguration;
import io.quarkus.vertx.http.runtime.security.CertificateRoleAttribute;
import io.quarkus.vertx.http.runtime.security.HttpSecurityUtils;
import io.quarkus.vertx.http.runtime.security.MtlsAuthenticationMechanism;
import io.smallrye.common.annotation.Experimental;
import io.vertx.core.http.ClientAuth;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

@Experimental(value="This API is currently experimental and might get changed")
public interface MTLS {
    public static MtlsAuthenticationMechanism request(String tlsConfigurationName) {
        return MTLS.builder().authentication(ClientAuth.REQUEST).tls(tlsConfigurationName).build();
    }

    public static MtlsAuthenticationMechanism request(String tlsConfigurationName, TlsConfiguration tlsConfiguration) {
        return MTLS.builder().authentication(ClientAuth.REQUEST).tls(tlsConfigurationName, tlsConfiguration).build();
    }

    public static MtlsAuthenticationMechanism request() {
        return MTLS.builder().authentication(ClientAuth.REQUEST).build();
    }

    public static MtlsAuthenticationMechanism required(String tlsConfigurationName, TlsConfiguration tlsConfiguration) {
        return MTLS.builder().tls(tlsConfigurationName, tlsConfiguration).build();
    }

    public static MtlsAuthenticationMechanism required(String tlsConfigurationName) {
        return MTLS.builder().tls(tlsConfigurationName).build();
    }

    public static MtlsAuthenticationMechanism required() {
        return MTLS.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ClientAuth clientAuth = ClientAuth.REQUIRED;
        private Function<X509Certificate, Set<String>> certificateToRolesMapper = null;
        private String certificateAttribute = null;
        private Map<String, Set<String>> certificateAttributeValueToRoles = null;
        private Optional<String> httpServerTlsConfigName = Optional.empty();
        private TlsConfiguration tlsConfiguration = null;

        public Builder tls(String tlsConfigurationName) {
            if (this.tlsConfiguration != null) {
                throw new IllegalStateException("TLS configuration is already set");
            }
            this.httpServerTlsConfigName = Optional.ofNullable(tlsConfigurationName);
            return this;
        }

        public Builder tls(String tlsConfigurationName, TlsConfiguration tlsConfiguration) {
            Objects.requireNonNull(tlsConfiguration);
            Objects.requireNonNull(tlsConfigurationName);
            if (this.httpServerTlsConfigName.isPresent()) {
                throw new IllegalArgumentException("TLS configuration name has already been configured with the 'tls' method");
            }
            this.httpServerTlsConfigName = Optional.of(tlsConfigurationName);
            this.tlsConfiguration = tlsConfiguration;
            return this;
        }

        public Builder authentication(ClientAuth clientAuthentication) {
            Objects.requireNonNull(clientAuthentication);
            if (clientAuthentication == ClientAuth.NONE) {
                throw new IllegalArgumentException("Client authentication cannot be disabled with this API");
            }
            this.clientAuth = clientAuthentication;
            return this;
        }

        public Builder certificateAttribute(String certificateAttribute) {
            this.assertCertificateToRolesMapperNotSetYet();
            this.certificateAttribute = Objects.requireNonNull(certificateAttribute);
            return this;
        }

        public Builder rolesMapping(String certificateAttributeValue, String ... roles) {
            return this.rolesMapping(certificateAttributeValue, Set.of(roles));
        }

        public Builder rolesMapping(String certificateAttributeValue, Set<String> roles) {
            Objects.requireNonNull(certificateAttributeValue);
            if (roles == null || roles.isEmpty()) {
                throw new IllegalArgumentException("Roles cannot be null or empty");
            }
            this.assertCertificateToRolesMapperNotSetYet();
            if (this.certificateAttributeValueToRoles == null) {
                this.certificateAttributeValueToRoles = new HashMap<String, Set<String>>();
            }
            this.certificateAttributeValueToRoles.computeIfAbsent(certificateAttributeValue, new Function<String, Set<String>>(){

                @Override
                public Set<String> apply(String ignored) {
                    return new HashSet<String>();
                }
            }).addAll(roles);
            return this;
        }

        private void assertCertificateToRolesMapperNotSetYet() {
            if (this.certificateToRolesMapper != null) {
                throw new IllegalStateException("The certificate to roles mapper is already configured with the 'certificateToRolesMapper' method");
            }
        }

        public Builder certificateToRolesMapper(Function<X509Certificate, Set<String>> certificateToRolesMapper) {
            if (this.certificateAttributeValueToRoles != null) {
                throw new IllegalStateException("The certificate to roles mapper is already configured with the 'rolesMapping' method");
            }
            this.assertCertificateToRolesMapperNotSetYet();
            this.certificateToRolesMapper = certificateToRolesMapper;
            return this;
        }

        public MtlsAuthenticationMechanism build() {
            if (this.certificateAttributeValueToRoles != null) {
                if (this.certificateAttribute == null) {
                    this.certificateAttribute = Builder.getDefaultCertificateAttributeValue();
                }
                this.certificateToRolesMapper = new CertificateRoleAttribute(this.certificateAttribute, this.certificateAttributeValueToRoles).rolesMapper();
            }
            MTLSConfig mTlsConfig = new MTLSConfig(this.certificateToRolesMapper, this.clientAuth, this.httpServerTlsConfigName, this.tlsConfiguration);
            return new MtlsAuthenticationMechanism(mTlsConfig);
        }

        private static String getDefaultCertificateAttributeValue() {
            return HttpSecurityUtils.getDefaultAuthConfig().auth().certificateRoleAttribute();
        }

        public static final class MTLSConfig {
            public final Function<X509Certificate, Set<String>> certificateToRoles;
            public final ClientAuth tlsClientAuth;
            public final Optional<String> httpServerTlsConfigName;
            public final TlsConfiguration initialTlsConfiguration;

            private MTLSConfig(Function<X509Certificate, Set<String>> certificateToRoles, ClientAuth tlsClientAuth, Optional<String> httpServerTlsConfigName, TlsConfiguration initialTlsConfiguration) {
                this.certificateToRoles = certificateToRoles;
                this.tlsClientAuth = tlsClientAuth;
                this.httpServerTlsConfigName = httpServerTlsConfigName;
                this.initialTlsConfiguration = initialTlsConfiguration;
            }
        }
    }
}

