/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.extension.persistence.impl.eclipselink;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.polaris.core.PolarisDiagnostics;
import org.apache.polaris.core.entity.EntityNameLookupRecord;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntitiesActiveKey;
import org.apache.polaris.core.entity.PolarisEntityCore;
import org.apache.polaris.core.entity.PolarisEntityId;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.entity.PolarisGrantRecord;
import org.apache.polaris.core.entity.PolarisPrincipalSecrets;
import org.apache.polaris.core.persistence.pagination.EntityIdToken;
import org.apache.polaris.core.persistence.pagination.PageToken;
import org.apache.polaris.core.policy.PolarisPolicyMappingRecord;
import org.apache.polaris.core.policy.PolicyEntity;
import org.apache.polaris.extension.persistence.impl.eclipselink.PolarisSequenceUtil;
import org.apache.polaris.extension.persistence.impl.eclipselink.models.ModelEntity;
import org.apache.polaris.extension.persistence.impl.eclipselink.models.ModelEntityActive;
import org.apache.polaris.extension.persistence.impl.eclipselink.models.ModelEntityChangeTracking;
import org.apache.polaris.extension.persistence.impl.eclipselink.models.ModelGrantRecord;
import org.apache.polaris.extension.persistence.impl.eclipselink.models.ModelPolicyMappingRecord;
import org.apache.polaris.extension.persistence.impl.eclipselink.models.ModelPrincipalSecrets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolarisEclipseLinkStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisEclipseLinkStore.class);
    private final PolarisDiagnostics diagnosticServices;
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    public PolarisEclipseLinkStore(@Nonnull PolarisDiagnostics diagnostics) {
        this.diagnosticServices = diagnostics;
    }

    public void initialize(EntityManager session) {
        PolarisSequenceUtil.initialize(session);
        this.initialized.set(true);
    }

    long getNextSequence(EntityManager session) {
        this.diagnosticServices.check(session != null, "session_is_null");
        this.checkInitialized();
        return PolarisSequenceUtil.getNewId(session);
    }

    void writeToEntities(EntityManager session, PolarisBaseEntity entity) {
        this.diagnosticServices.check(session != null, "session_is_null");
        this.checkInitialized();
        ModelEntity model = this.lookupEntity(session, entity.getCatalogId(), entity.getId(), entity.getTypeCode());
        if (model != null) {
            model.update(entity);
        } else {
            model = ModelEntity.fromEntity(entity);
        }
        session.persist((Object)model);
    }

    void writeToEntitiesActive(EntityManager session, PolarisBaseEntity entity) {
        this.diagnosticServices.check(session != null, "session_is_null");
        this.checkInitialized();
        ModelEntityActive model = this.lookupEntityActive(session, new PolarisEntitiesActiveKey((PolarisEntityCore)entity));
        if (model == null) {
            session.persist((Object)ModelEntityActive.fromEntityActive(new EntityNameLookupRecord(entity)));
        }
    }

    void writeToEntitiesChangeTracking(EntityManager session, PolarisBaseEntity entity) {
        this.diagnosticServices.check(session != null, "session_is_null");
        this.checkInitialized();
        ModelEntityChangeTracking entityChangeTracking = this.lookupEntityChangeTracking(session, entity.getCatalogId(), entity.getId());
        if (entityChangeTracking != null) {
            entityChangeTracking.update(entity);
        } else {
            entityChangeTracking = new ModelEntityChangeTracking(entity);
        }
        session.persist((Object)entityChangeTracking);
    }

    void writeToGrantRecords(EntityManager session, PolarisGrantRecord grantRec) {
        this.diagnosticServices.check(session != null, "session_is_null");
        this.checkInitialized();
        session.persist((Object)ModelGrantRecord.fromGrantRecord(grantRec));
    }

    void deleteFromEntities(EntityManager session, long catalogId, long entityId, int typeCode) {
        this.diagnosticServices.check(session != null, "session_is_null");
        this.checkInitialized();
        ModelEntity model = this.lookupEntity(session, catalogId, entityId, typeCode);
        this.diagnosticServices.check(model != null, "entity_not_found");
        session.remove((Object)model);
    }

    void deleteFromEntitiesActive(EntityManager session, PolarisEntitiesActiveKey key) {
        this.diagnosticServices.check(session != null, "session_is_null");
        this.checkInitialized();
        ModelEntityActive entity = this.lookupEntityActive(session, key);
        this.diagnosticServices.check(entity != null, "active_entity_not_found");
        session.remove((Object)entity);
    }

    void deleteFromEntitiesChangeTracking(EntityManager session, PolarisEntityCore entity) {
        this.diagnosticServices.check(session != null, "session_is_null");
        this.checkInitialized();
        ModelEntityChangeTracking entityChangeTracking = this.lookupEntityChangeTracking(session, entity.getCatalogId(), entity.getId());
        this.diagnosticServices.check(entityChangeTracking != null, "change_tracking_entity_not_found");
        session.remove((Object)entityChangeTracking);
    }

    void deleteFromGrantRecords(EntityManager session, PolarisGrantRecord grantRec) {
        this.diagnosticServices.check(session != null, "session_is_null");
        this.checkInitialized();
        ModelGrantRecord lookupGrantRecord = this.lookupGrantRecord(session, grantRec.getSecurableCatalogId(), grantRec.getSecurableId(), grantRec.getGranteeCatalogId(), grantRec.getGranteeId(), grantRec.getPrivilegeCode());
        this.diagnosticServices.check(lookupGrantRecord != null, "grant_record_not_found");
        session.remove((Object)lookupGrantRecord);
    }

    void deleteAllEntityGrantRecords(EntityManager session, PolarisEntityCore entity) {
        this.diagnosticServices.check(session != null, "session_is_null");
        this.checkInitialized();
        this.lookupAllGrantRecordsOnSecurable(session, entity.getCatalogId(), entity.getId()).forEach(arg_0 -> ((EntityManager)session).remove(arg_0));
        this.lookupGrantRecordsOnGrantee(session, entity.getCatalogId(), entity.getId()).forEach(arg_0 -> ((EntityManager)session).remove(arg_0));
    }

    void deleteAll(EntityManager session) {
        this.diagnosticServices.check(session != null, "session_is_null");
        this.checkInitialized();
        session.createQuery("DELETE from ModelEntity").executeUpdate();
        session.createQuery("DELETE from ModelEntityActive").executeUpdate();
        session.createQuery("DELETE from ModelEntityChangeTracking").executeUpdate();
        session.createQuery("DELETE from ModelGrantRecord").executeUpdate();
        session.createQuery("DELETE from ModelPrincipalSecrets").executeUpdate();
        LOGGER.debug("All entities deleted.");
    }

    ModelEntity lookupEntity(EntityManager session, long catalogId, long entityId, long typeCode) {
        this.diagnosticServices.check(session != null, "session_is_null");
        this.checkInitialized();
        return session.createQuery("SELECT m from ModelEntity m where m.catalogId=:catalogId and m.id=:id and m.typeCode=:typeCode", ModelEntity.class).setParameter("typeCode", (Object)typeCode).setParameter("catalogId", (Object)catalogId).setParameter("id", (Object)entityId).getResultStream().findFirst().orElse(null);
    }

    List<ModelEntity> lookupEntities(EntityManager session, List<PolarisEntityId> entityIds) {
        this.diagnosticServices.check(session != null, "session_is_null");
        this.checkInitialized();
        if (entityIds == null || entityIds.isEmpty()) {
            return new ArrayList<ModelEntity>();
        }
        String inClause = entityIds.stream().map(entityId -> "(" + entityId.getCatalogId() + "," + entityId.getId() + ")").collect(Collectors.joining(","));
        String hql = "SELECT * from ENTITIES m where (m.catalogId, m.id) in (" + inClause + ")";
        return session.createNativeQuery(hql, ModelEntity.class).getResultList();
    }

    ModelEntityActive lookupEntityActive(EntityManager session, PolarisEntitiesActiveKey entityActiveKey) {
        this.diagnosticServices.check(session != null, "session_is_null");
        this.checkInitialized();
        return session.createQuery("SELECT m from ModelEntityActive m where m.catalogId=:catalogId and m.parentId=:parentId and m.typeCode=:typeCode and m.name=:name", ModelEntityActive.class).setParameter("catalogId", (Object)entityActiveKey.getCatalogId()).setParameter("parentId", (Object)entityActiveKey.getParentId()).setParameter("typeCode", (Object)entityActiveKey.getTypeCode()).setParameter("name", (Object)entityActiveKey.getName()).getResultStream().findFirst().orElse(null);
    }

    long countActiveChildEntities(EntityManager session, long catalogId, long parentId, @Nullable PolarisEntityType entityType) {
        this.diagnosticServices.check(session != null, "session_is_null");
        this.checkInitialized();
        Object hql = "SELECT COUNT(m) from ModelEntityActive m where m.catalogId=:catalogId and m.parentId=:parentId";
        if (entityType != null) {
            hql = (String)hql + " and m.typeCode=:typeCode";
        }
        TypedQuery query = session.createQuery((String)hql, Long.class).setParameter("catalogId", (Object)catalogId).setParameter("parentId", (Object)parentId);
        if (entityType != null) {
            query.setParameter("typeCode", (Object)entityType.getCode());
        }
        return (Long)query.getSingleResult();
    }

    List<ModelEntity> lookupFullEntitiesActive(EntityManager session, long catalogId, long parentId, @Nonnull PolarisEntityType entityType, @Nonnull PolarisEntitySubType entitySubType, @Nonnull PageToken pageToken) {
        Optional entityIdToken;
        this.diagnosticServices.check(session != null, "session_is_null");
        this.checkInitialized();
        Object hql = "SELECT m from ModelEntity m where m.catalogId=:catalogId and m.parentId=:parentId and m.typeCode=:typeCode";
        if (entitySubType != PolarisEntitySubType.ANY_SUBTYPE) {
            hql = (String)hql + " and m.subTypeCode=:subTypeCode";
        }
        if ((entityIdToken = pageToken.valueAs(EntityIdToken.class)).isPresent()) {
            hql = (String)hql + " and m.id > :tokenId";
        }
        if (pageToken.paginationRequested()) {
            hql = (String)hql + " order by m.id asc";
        }
        TypedQuery query = session.createQuery((String)hql, ModelEntity.class).setParameter("catalogId", (Object)catalogId).setParameter("parentId", (Object)parentId).setParameter("typeCode", (Object)entityType.getCode());
        if (entitySubType != PolarisEntitySubType.ANY_SUBTYPE) {
            query.setParameter("subTypeCode", (Object)entitySubType.getCode());
        }
        if (entityIdToken.isPresent()) {
            long tokenId = ((EntityIdToken)entityIdToken.get()).entityId();
            query = query.setParameter("tokenId", (Object)tokenId);
        }
        return query.getResultList();
    }

    ModelEntityChangeTracking lookupEntityChangeTracking(EntityManager session, long catalogId, long entityId) {
        this.diagnosticServices.check(session != null, "session_is_null");
        this.checkInitialized();
        return session.createQuery("SELECT m from ModelEntityChangeTracking m where m.catalogId=:catalogId and m.id=:id", ModelEntityChangeTracking.class).setParameter("catalogId", (Object)catalogId).setParameter("id", (Object)entityId).getResultStream().findFirst().orElse(null);
    }

    ModelGrantRecord lookupGrantRecord(EntityManager session, long securableCatalogId, long securableId, long granteeCatalogId, long granteeId, int privilegeCode) {
        this.diagnosticServices.check(session != null, "session_is_null");
        this.checkInitialized();
        return session.createQuery("SELECT m from ModelGrantRecord m where m.securableCatalogId=:securableCatalogId and m.securableId=:securableId and m.granteeCatalogId=:granteeCatalogId and m.granteeId=:granteeId and m.privilegeCode=:privilegeCode", ModelGrantRecord.class).setParameter("securableCatalogId", (Object)securableCatalogId).setParameter("securableId", (Object)securableId).setParameter("granteeCatalogId", (Object)granteeCatalogId).setParameter("granteeId", (Object)granteeId).setParameter("privilegeCode", (Object)privilegeCode).getResultStream().findFirst().orElse(null);
    }

    List<ModelGrantRecord> lookupAllGrantRecordsOnSecurable(EntityManager session, long securableCatalogId, long securableId) {
        this.diagnosticServices.check(session != null, "session_is_null");
        this.checkInitialized();
        return session.createQuery("SELECT m from ModelGrantRecord m where m.securableCatalogId=:securableCatalogId and m.securableId=:securableId", ModelGrantRecord.class).setParameter("securableCatalogId", (Object)securableCatalogId).setParameter("securableId", (Object)securableId).getResultList();
    }

    List<ModelGrantRecord> lookupGrantRecordsOnGrantee(EntityManager session, long granteeCatalogId, long granteeId) {
        this.diagnosticServices.check(session != null, "session_is_null");
        this.checkInitialized();
        return session.createQuery("SELECT m from ModelGrantRecord m where m.granteeCatalogId=:granteeCatalogId and m.granteeId=:granteeId", ModelGrantRecord.class).setParameter("granteeCatalogId", (Object)granteeCatalogId).setParameter("granteeId", (Object)granteeId).getResultList();
    }

    ModelPrincipalSecrets lookupPrincipalSecrets(EntityManager session, String clientId) {
        this.diagnosticServices.check(session != null, "session_is_null");
        this.checkInitialized();
        return session.createQuery("SELECT m from ModelPrincipalSecrets m where m.principalClientId=:clientId", ModelPrincipalSecrets.class).setParameter("clientId", (Object)clientId).getResultStream().findFirst().orElse(null);
    }

    void writePrincipalSecrets(EntityManager session, PolarisPrincipalSecrets principalSecrets) {
        this.diagnosticServices.check(session != null, "session_is_null");
        this.checkInitialized();
        ModelPrincipalSecrets modelPrincipalSecrets = this.lookupPrincipalSecrets(session, principalSecrets.getPrincipalClientId());
        if (modelPrincipalSecrets != null) {
            modelPrincipalSecrets.update(principalSecrets);
        } else {
            modelPrincipalSecrets = ModelPrincipalSecrets.fromPrincipalSecrets(principalSecrets);
        }
        session.persist((Object)modelPrincipalSecrets);
    }

    void deletePrincipalSecrets(EntityManager session, String clientId) {
        this.diagnosticServices.check(session != null, "session_is_null");
        this.checkInitialized();
        ModelPrincipalSecrets modelPrincipalSecrets = this.lookupPrincipalSecrets(session, clientId);
        this.diagnosticServices.check(modelPrincipalSecrets != null, "principal_secretes_not_found");
        session.remove((Object)modelPrincipalSecrets);
    }

    void writeToPolicyMappingRecords(EntityManager session, PolarisPolicyMappingRecord mappingRecord) {
        this.diagnosticServices.check(session != null, "session_is_null");
        this.checkInitialized();
        ModelPolicyMappingRecord model = this.lookupPolicyMappingRecord(session, mappingRecord.getTargetCatalogId(), mappingRecord.getTargetId(), mappingRecord.getPolicyTypeCode(), mappingRecord.getPolicyCatalogId(), mappingRecord.getPolicyId());
        if (model != null) {
            model.update(mappingRecord);
        } else {
            model = ModelPolicyMappingRecord.fromPolicyMappingRecord(mappingRecord);
        }
        session.persist((Object)model);
    }

    void deleteFromPolicyMappingRecords(EntityManager session, PolarisPolicyMappingRecord mappingRecord) {
        this.diagnosticServices.check(session != null, "session_is_null");
        this.checkInitialized();
        ModelPolicyMappingRecord lookupPolicyMappingRecord = this.lookupPolicyMappingRecord(session, mappingRecord.getTargetCatalogId(), mappingRecord.getTargetId(), mappingRecord.getPolicyTypeCode(), mappingRecord.getPolicyCatalogId(), mappingRecord.getPolicyId());
        this.diagnosticServices.check(lookupPolicyMappingRecord != null, "policy_mapping_record_not_found");
        session.remove((Object)lookupPolicyMappingRecord);
    }

    void deleteAllEntityPolicyMappingRecords(EntityManager session, PolarisBaseEntity entity) {
        this.diagnosticServices.check(session != null, "session_is_null");
        this.checkInitialized();
        if (entity.getType() == PolarisEntityType.POLICY) {
            PolicyEntity policyEntity = PolicyEntity.of((PolarisBaseEntity)entity);
            this.loadAllTargetsOnPolicy(session, policyEntity.getCatalogId(), policyEntity.getId(), policyEntity.getPolicyTypeCode()).forEach(arg_0 -> ((EntityManager)session).remove(arg_0));
        } else {
            this.loadAllPoliciesOnTarget(session, entity.getCatalogId(), entity.getId()).forEach(arg_0 -> ((EntityManager)session).remove(arg_0));
        }
    }

    ModelPolicyMappingRecord lookupPolicyMappingRecord(EntityManager session, long targetCatalogId, long targetId, int policyTypeCode, long policyCatalogId, long policyId) {
        this.diagnosticServices.check(session != null, "session_is_null");
        this.checkInitialized();
        return session.createQuery("SELECT m from ModelPolicyMappingRecord m where m.targetCatalogId=:targetCatalogId and m.targetId=:targetId and m.policyTypeCode=:policyTypeCode and m.policyCatalogId=:policyCatalogId and m.policyId=:policyId", ModelPolicyMappingRecord.class).setParameter("targetCatalogId", (Object)targetCatalogId).setParameter("targetId", (Object)targetId).setParameter("policyTypeCode", (Object)policyTypeCode).setParameter("policyCatalogId", (Object)policyCatalogId).setParameter("policyId", (Object)policyId).getResultStream().findFirst().orElse(null);
    }

    List<ModelPolicyMappingRecord> loadPoliciesOnTargetByType(EntityManager session, long targetCatalogId, long targetId, int policyTypeCode) {
        this.diagnosticServices.check(session != null, "session_is_null");
        this.checkInitialized();
        return session.createQuery("SELECT m from ModelPolicyMappingRecord m where m.targetCatalogId=:targetCatalogId and m.targetId=:targetId and m.policyTypeCode=:policyTypeCode", ModelPolicyMappingRecord.class).setParameter("targetCatalogId", (Object)targetCatalogId).setParameter("targetId", (Object)targetId).setParameter("policyTypeCode", (Object)policyTypeCode).getResultList();
    }

    List<ModelPolicyMappingRecord> loadAllPoliciesOnTarget(EntityManager session, long targetCatalogId, long targetId) {
        this.diagnosticServices.check(session != null, "session_is_null");
        this.checkInitialized();
        return session.createQuery("SELECT m from ModelPolicyMappingRecord m  where m.targetCatalogId=:targetCatalogId and m.targetId=:targetId", ModelPolicyMappingRecord.class).setParameter("targetCatalogId", (Object)targetCatalogId).setParameter("targetId", (Object)targetId).getResultList();
    }

    List<ModelPolicyMappingRecord> loadAllTargetsOnPolicy(EntityManager session, long policyCatalogId, long policyId, int policyTypeCode) {
        this.diagnosticServices.check(session != null, "session_is_null");
        this.checkInitialized();
        return session.createQuery("SELECT m from ModelPolicyMappingRecord m where m.policyTypeCode=:policyTypeCode and m.policyCatalogId=:policyCatalogId and m.policyId=:policyId", ModelPolicyMappingRecord.class).setParameter("policyTypeCode", (Object)policyTypeCode).setParameter("policyCatalogId", (Object)policyCatalogId).setParameter("policyId", (Object)policyId).getResultList();
    }

    private void checkInitialized() {
        this.diagnosticServices.check(this.initialized.get(), "store_not_initialized");
    }
}

