/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.paging;

import com.azure.core.util.IterableStream;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.paging.ContinuablePage;
import com.azure.core.util.paging.ContinuablePagedByItemIterable;
import com.azure.core.util.paging.ContinuablePagedByPageIterable;
import com.azure.core.util.paging.ContinuablePagedFlux;
import com.azure.core.util.paging.ContinuablePagedFluxCore;
import com.azure.core.util.paging.PageRetrieverSync;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ContinuablePagedIterable<C, T, P extends ContinuablePage<C, T>>
extends IterableStream<T> {
    private static final ClientLogger LOGGER = new ClientLogger(ContinuablePagedIterable.class);
    private final ContinuablePagedFlux<C, T, P> pagedFlux;
    private final int batchSize;
    private final Supplier<PageRetrieverSync<C, P>> pageRetrieverSyncProvider;
    final Integer defaultPageSize;
    private final Predicate<C> continuationPredicate;

    public ContinuablePagedIterable(ContinuablePagedFlux<C, T, P> pagedFlux) {
        this(pagedFlux, 1);
    }

    public ContinuablePagedIterable(ContinuablePagedFlux<C, T, P> pagedFlux, int batchSize) {
        super(pagedFlux);
        this.pagedFlux = pagedFlux;
        this.batchSize = batchSize;
        this.defaultPageSize = null;
        this.continuationPredicate = null;
        this.pageRetrieverSyncProvider = null;
    }

    public ContinuablePagedIterable(Supplier<PageRetrieverSync<C, P>> pageRetrieverSyncProvider, Integer pageSize, Predicate<C> continuationPredicate) {
        super(new ContinuablePagedByItemIterable(pageRetrieverSyncProvider.get(), null, continuationPredicate, pageSize));
        this.pageRetrieverSyncProvider = Objects.requireNonNull(pageRetrieverSyncProvider, "'pageRetrieverSyncProvider' function cannot be null.");
        if (pageSize != null && pageSize <= 0) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'pageSize' must be greater than 0 required but provided: " + pageSize));
        }
        this.continuationPredicate = continuationPredicate == null ? Objects::nonNull : continuationPredicate;
        this.defaultPageSize = pageSize;
        this.batchSize = 1;
        this.pagedFlux = null;
    }

    @Override
    public Stream<T> stream() {
        return StreamSupport.stream(this.iterableByItemInternal().spliterator(), false);
    }

    public Stream<P> streamByPage() {
        return this.streamByPageInternal(null, null, () -> this.pagedFlux.byPage().toStream(this.batchSize));
    }

    public Stream<P> streamByPage(C continuationToken) {
        return this.streamByPageInternal(continuationToken, null, () -> this.pagedFlux.byPage(continuationToken).toStream(this.batchSize));
    }

    public Stream<P> streamByPage(int preferredPageSize) {
        return this.streamByPageInternal(null, preferredPageSize, () -> this.pagedFlux.byPage(preferredPageSize).toStream(this.batchSize));
    }

    public Stream<P> streamByPage(C continuationToken, int preferredPageSize) {
        return this.streamByPageInternal(continuationToken, preferredPageSize, () -> this.pagedFlux.byPage(continuationToken, preferredPageSize).toStream(this.batchSize));
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterableByItemInternal().iterator();
    }

    public Iterable<P> iterableByPage() {
        return this.iterableByPageInternal(null, null, () -> this.pagedFlux.byPage().toIterable(this.batchSize));
    }

    public Iterable<P> iterableByPage(C continuationToken) {
        return this.iterableByPageInternal(continuationToken, null, () -> this.pagedFlux.byPage(continuationToken).toIterable(this.batchSize));
    }

    public Iterable<P> iterableByPage(int preferredPageSize) {
        return this.iterableByPageInternal(null, preferredPageSize, () -> this.pagedFlux.byPage(preferredPageSize).toIterable(this.batchSize));
    }

    public Iterable<P> iterableByPage(C continuationToken, int preferredPageSize) {
        return this.iterableByPageInternal(continuationToken, preferredPageSize, () -> this.pagedFlux.byPage(continuationToken, preferredPageSize).toIterable(this.batchSize));
    }

    private Stream<P> streamByPageInternal(C continuationToken, Integer preferredPageSize, Supplier<Stream<P>> nonPagedFluxCoreIterableSupplier) {
        if (this.pagedFlux == null) {
            return StreamSupport.stream(this.iterableByPageInternal(continuationToken, preferredPageSize, null).spliterator(), false);
        }
        if (this.pagedFlux instanceof ContinuablePagedFluxCore) {
            return StreamSupport.stream(this.iterableByPageInternal(continuationToken, preferredPageSize, null).spliterator(), false);
        }
        return nonPagedFluxCoreIterableSupplier.get();
    }

    private Iterable<P> iterableByPageInternal(C continuationToken, Integer preferredPageSize, Supplier<Iterable<P>> nonPagedFluxCoreIterableSupplier) {
        if (this.pagedFlux == null) {
            return new ContinuablePagedByPageIterable(this.pageRetrieverSyncProvider.get(), continuationToken, this.continuationPredicate, preferredPageSize);
        }
        if (this.pagedFlux instanceof ContinuablePagedFluxCore) {
            ContinuablePagedFluxCore pagedFluxCore = (ContinuablePagedFluxCore)this.pagedFlux;
            return new ContinuablePagedByPageIterable(pagedFluxCore.pageRetrieverProvider.get(), continuationToken, pagedFluxCore.getContinuationPredicate(), preferredPageSize);
        }
        return nonPagedFluxCoreIterableSupplier.get();
    }

    private Iterable<T> iterableByItemInternal() {
        if (this.pagedFlux == null) {
            return new ContinuablePagedByItemIterable(this.pageRetrieverSyncProvider.get(), null, this.continuationPredicate, null);
        }
        if (this.pagedFlux instanceof ContinuablePagedFluxCore) {
            ContinuablePagedFluxCore pagedFluxCore = (ContinuablePagedFluxCore)this.pagedFlux;
            return new ContinuablePagedByItemIterable(pagedFluxCore.pageRetrieverProvider.get(), null, pagedFluxCore.getContinuationPredicate(), null);
        }
        return this.pagedFlux.toIterable(this.batchSize);
    }
}

