/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.policy.validator;

import com.google.common.base.Preconditions;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.policy.PolicyEntity;
import org.apache.polaris.core.policy.PredefinedPolicyTypes;
import org.apache.polaris.core.policy.content.maintenance.DataCompactionPolicyContent;
import org.apache.polaris.core.policy.content.maintenance.MetadataCompactionPolicyContent;
import org.apache.polaris.core.policy.content.maintenance.OrphanFileRemovalPolicyContent;
import org.apache.polaris.core.policy.content.maintenance.SnapshotExpiryPolicyContent;
import org.apache.polaris.core.policy.exceptions.PolicyAttachException;
import org.apache.polaris.core.policy.validator.maintenance.BaseMaintenancePolicyValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyValidators {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolicyValidators.class);

    public static void validate(PolicyEntity policy) {
        Preconditions.checkNotNull((Object)policy, (Object)"Policy must not be null");
        PredefinedPolicyTypes type = PredefinedPolicyTypes.fromCode(policy.getPolicyTypeCode());
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)("Unknown policy type: " + policy.getPolicyTypeCode()));
        switch (type) {
            case DATA_COMPACTION: {
                DataCompactionPolicyContent.fromString(policy.getContent());
                break;
            }
            case METADATA_COMPACTION: {
                MetadataCompactionPolicyContent.fromString(policy.getContent());
                break;
            }
            case SNAPSHOT_EXPIRY: {
                SnapshotExpiryPolicyContent.fromString(policy.getContent());
                break;
            }
            case ORPHAN_FILE_REMOVAL: {
                OrphanFileRemovalPolicyContent.fromString(policy.getContent());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported policy type: " + type.getName());
            }
        }
        LOGGER.info("Policy validated successfully: {}", (Object)type.getName());
    }

    public static boolean canAttach(PolicyEntity policy, PolarisEntity targetEntity) {
        Preconditions.checkNotNull((Object)policy, (Object)"Policy must not be null");
        Preconditions.checkNotNull((Object)targetEntity, (Object)"Target entity must not be null");
        PredefinedPolicyTypes policyType = PredefinedPolicyTypes.fromCode(policy.getPolicyTypeCode());
        Preconditions.checkArgument((policyType != null ? 1 : 0) != 0, (Object)("Unknown policy type: " + policy.getPolicyTypeCode()));
        PolarisEntityType entityType = targetEntity.getType();
        PolarisEntitySubType entitySubType = targetEntity.getSubType();
        switch (policyType) {
            case DATA_COMPACTION: 
            case METADATA_COMPACTION: 
            case SNAPSHOT_EXPIRY: 
            case ORPHAN_FILE_REMOVAL: {
                return BaseMaintenancePolicyValidator.INSTANCE.canAttach(entityType, entitySubType);
            }
        }
        LOGGER.warn("Attachment not supported for policy type: {}", (Object)policyType.getName());
        return false;
    }

    public static void validateAttach(PolicyEntity policy, PolarisEntity targetEntity) {
        if (!PolicyValidators.canAttach(policy, targetEntity)) {
            throw new PolicyAttachException("Cannot attach policy '%s' to target entity '%s'", policy.getName(), targetEntity.getName());
        }
    }
}

