/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baserpc.client.loadbalancer;

import com.google.common.base.Charsets;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import java.util.Collection;
import java.util.SortedMap;
import java.util.TreeMap;

class WCHRouter<T> {
    private final SortedMap<Long, VirtualNode<T>> ring = new TreeMap<Long, VirtualNode<T>>();
    private final HashFunction hashFunction;
    private final KeyFunction<T> keyFunction;

    WCHRouter(Collection<T> pNodes, KeyFunction<T> keyFunction, WeightFunction<T> weightFunction, int vNodeCount) {
        this(pNodes, keyFunction, weightFunction, vNodeCount, new Murmur3());
    }

    WCHRouter(Collection<T> pNodes, KeyFunction<T> keyFunction, WeightFunction<T> weightFunction, int vNodeCount, HashFunction hashFunction) {
        this.keyFunction = keyFunction;
        this.hashFunction = hashFunction;
        if (pNodes != null) {
            for (T pNode : pNodes) {
                int weight = weightFunction.getWeight(pNode);
                this.addNode(pNode, vNodeCount * weight);
            }
        }
    }

    void addNode(T pNode, int nodeCount) {
        if (nodeCount < 0) {
            throw new IllegalArgumentException("illegal virtual node counts :" + nodeCount);
        }
        int existingReplicas = this.getExistingReplicas(pNode);
        for (int i = 0; i < nodeCount; ++i) {
            VirtualNode<T> vNode = new VirtualNode<T>(pNode, i + existingReplicas, this.keyFunction);
            this.ring.put(this.hashFunction.hash(vNode.getKey()), vNode);
        }
    }

    T routeNode(String objectKey) {
        if (this.ring.isEmpty()) {
            return null;
        }
        Long hashVal = this.hashFunction.hash(objectKey);
        SortedMap<Long, VirtualNode<T>> tailMap = this.ring.tailMap(hashVal);
        Long nodeHashVal = !tailMap.isEmpty() ? tailMap.firstKey() : this.ring.firstKey();
        return ((VirtualNode)this.ring.get(nodeHashVal)).getPhysicalNode();
    }

    boolean isEmpty() {
        return this.ring.isEmpty();
    }

    int getExistingReplicas(T pNode) {
        int replicas = 0;
        for (VirtualNode<T> vNode : this.ring.values()) {
            if (!vNode.isVirtualNodeOf(pNode)) continue;
            ++replicas;
        }
        return replicas;
    }

    private static class Murmur3
    implements HashFunction {
        com.google.common.hash.HashFunction hash = Hashing.murmur3_128();

        Murmur3() {
        }

        @Override
        public long hash(String key) {
            HashCode code = this.hash.hashString((CharSequence)key, Charsets.UTF_8);
            return code.asLong();
        }
    }

    static interface KeyFunction<T> {
        public String getKey(T var1);
    }

    static interface WeightFunction<T> {
        public int getWeight(T var1);
    }

    static interface HashFunction {
        public long hash(String var1);
    }

    static class VirtualNode<T> {
        final T physicalNode;
        final int replicaIndex;
        final KeyFunction<T> keyFunction;
        final String pNodeKey;
        final String vNodekey;

        VirtualNode(T physicalNode, int replicaIndex, KeyFunction<T> keyFunc) {
            this.replicaIndex = replicaIndex;
            this.physicalNode = physicalNode;
            this.keyFunction = keyFunc;
            this.pNodeKey = this.keyFunction.getKey(physicalNode);
            this.vNodekey = this.pNodeKey + "-" + replicaIndex;
        }

        public String getKey() {
            return this.vNodekey;
        }

        boolean isVirtualNodeOf(T pNode) {
            return this.pNodeKey.equals(this.keyFunction.getKey(pNode));
        }

        T getPhysicalNode() {
            return this.physicalNode;
        }
    }
}

