/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.raft.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.ignite3.internal.network.NetworkMessage;
import org.apache.ignite3.internal.network.direct.DirectMessageReader;
import org.apache.ignite3.internal.network.direct.DirectMessageWriter;
import org.apache.ignite3.internal.network.direct.stream.DirectByteBufferStream;
import org.apache.ignite3.internal.network.direct.stream.DirectByteBufferStreamImplV1;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.network.serialization.MessageSerializationRegistry;
import org.apache.ignite3.internal.network.serialization.MessageWriter;
import org.apache.ignite3.internal.raft.Marshaller;
import org.apache.ignite3.internal.raft.util.EmptyByteBuffersPool;
import org.apache.ignite3.internal.raft.util.OptimizedStream;
import org.apache.ignite3.internal.util.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public class OptimizedMarshaller
implements Marshaller {
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    public static final int MAX_CACHED_BUFFER_BYTES = 262144;
    public static final ByteBuffersPool NO_POOL = new EmptyByteBuffersPool();
    private static final byte PROTO_VER = 1;
    public static final ByteOrder ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ByteBuffersPool pool;
    protected final OptimizedStream stream;
    private final MessageWriter messageWriter;
    private final MessageReader messageReader;

    public OptimizedMarshaller(MessageSerializationRegistry serializationRegistry, ByteBuffersPool pool) {
        this.pool = pool;
        this.stream = new OptimizedStream(serializationRegistry);
        this.messageWriter = new DirectMessageWriter(serializationRegistry, 1){

            @Override
            protected DirectByteBufferStreamImplV1 createStream(MessageSerializationRegistry serializationRegistry, byte protoVer) {
                assert (protoVer == 1) : protoVer;
                return new OptimizedStream(serializationRegistry);
            }
        };
        this.messageReader = new DirectMessageReader(serializationRegistry, 1){

            @Override
            protected DirectByteBufferStream createStream(MessageSerializationRegistry serializationRegistry, byte protoVer) {
                assert (protoVer == 1) : protoVer;
                return new OptimizedStream(serializationRegistry);
            }
        };
    }

    @Override
    public byte[] marshall(Object o) {
        assert (o instanceof NetworkMessage);
        ByteBuffer poolBuffer = this.pool.borrow();
        ByteBuffer buffer = poolBuffer == null ? ByteBuffer.allocate(1024).order(ORDER) : poolBuffer;
        NetworkMessage message = (NetworkMessage)o;
        this.beforeWriteMessage(o, buffer);
        while (true) {
            this.stream.setBuffer(buffer);
            this.stream.writeMessage(message, this.messageWriter);
            if (this.stream.lastFinished()) break;
            if ((buffer = this.expandBuffer(buffer)).capacity() <= 262144 && poolBuffer != null) {
                poolBuffer = buffer;
                continue;
            }
            if (poolBuffer == null) continue;
            poolBuffer.position(0);
            this.pool.release(poolBuffer);
            poolBuffer = null;
        }
        this.stream.setBuffer(ArrayUtils.EMPTY_BYTE_BUFFER);
        byte[] result = Arrays.copyOf(buffer.array(), buffer.position());
        if (poolBuffer != null) {
            poolBuffer.position(0);
            this.pool.release(poolBuffer);
        }
        return result;
    }

    protected void beforeWriteMessage(Object o, ByteBuffer buffer) {
    }

    @Override
    public <T> T unmarshall(ByteBuffer bytes) {
        this.stream.setBuffer(bytes.duplicate().order(ORDER));
        return this.stream.readMessage(this.messageReader);
    }

    private ByteBuffer expandBuffer(ByteBuffer buffer) {
        byte[] newArray = Arrays.copyOf(buffer.array(), (int)((double)buffer.capacity() * 1.5));
        return ByteBuffer.wrap(newArray).position(buffer.position()).order(ORDER);
    }

    public static interface ByteBuffersPool {
        @Nullable
        public ByteBuffer borrow();

        public void release(ByteBuffer var1);
    }
}

