/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.affinity.rendezvous;

import java.util.List;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.lang.IgniteBiPredicate;

public class ClusterNodeAttributeColocatedBackupFilter
implements IgniteBiPredicate<ClusterNode, List<ClusterNode>> {
    private static final long serialVersionUID = 1L;
    private final String attrName;

    public ClusterNodeAttributeColocatedBackupFilter(String attrName) {
        A.notNullOrEmpty(attrName, "attrName");
        this.attrName = attrName;
    }

    @Override
    public boolean apply(ClusterNode candidate, List<ClusterNode> previouslySelected) {
        A.notEmpty(previouslySelected, "previouslySelected");
        String primaryAttrVal = (String)previouslySelected.get(0).attribute(this.attrName);
        String candidateAttrVal = (String)candidate.attribute(this.attrName);
        if (primaryAttrVal == null || candidateAttrVal == null) {
            throw new IllegalStateException("Empty co-location attribute value");
        }
        return primaryAttrVal.equals(candidateAttrVal);
    }
}

