/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.ssl;

import java.security.Provider;
import java.security.Security;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public class DummyProvider
extends Provider {
    private final Provider realJSSEProvider = Security.getProvider("SunJSSE");
    private final Provider realJCEEProvider = Security.getProvider("SunJCE");
    static final String NAME = "FAKE";
    private final Set<String> requestedTypes = new HashSet<String>();
    private final ReentrantLock lock = new ReentrantLock();

    public DummyProvider() {
        super(NAME, 1.1, "http core fake provider 1.1");
    }

    public boolean hasBeenRequested(String what) {
        return this.requestedTypes.contains(what);
    }

    @Override
    public Provider.Service getService(String type, String algorithm) {
        this.requestedTypes.add(type);
        if ("KeyStore".equals(type)) {
            return this.realJCEEProvider.getService(type, algorithm);
        }
        return this.realJSSEProvider.getService(type, algorithm);
    }

    @Override
    public Set<Provider.Service> getServices() {
        this.lock.lock();
        try {
            Set<Provider.Service> set = this.realJSSEProvider.getServices();
            return set;
        }
        finally {
            this.lock.unlock();
        }
    }
}

