/*
 * Decompiled with CFR 0.152.
 */
package grails.init;

import grails.init.GrailsReleaseType;
import grails.init.GrailsVersion;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;

public class GrailsWrapperHome {
    public static final String CLI_COMBINED_PROJECT_NAME = "grails-cli";
    public final File home;
    public final File wrapperDirectory;
    public final List<GrailsVersion> versions;
    public final Set<GrailsReleaseType> allowedReleaseTypes;
    public final GrailsVersion latestVersion;

    public GrailsWrapperHome(LinkedHashSet<GrailsReleaseType> allowedReleaseTypes, String forcedGrailsHome) throws IOException {
        this.home = GrailsWrapperHome.findGrailsHome(forcedGrailsHome).getCanonicalFile();
        this.allowedReleaseTypes = allowedReleaseTypes == null ? new LinkedHashSet() : allowedReleaseTypes;
        this.wrapperDirectory = new File(this.home, "wrapper");
        if (!this.wrapperDirectory.exists()) {
            this.wrapperDirectory.mkdirs();
        } else if (!this.wrapperDirectory.isDirectory()) {
            throw new IllegalStateException("GRAILS_WRAPPER_HOME must contain a wrapper directory. File exists instead at " + this.wrapperDirectory.getAbsolutePath());
        }
        this.versions = this.determineVersions();
        this.latestVersion = this.findLatestVersion();
    }

    File getLatestVersionDirectory() {
        return this.getVersionDirectory(this.latestVersion);
    }

    File getVersionDirectory(GrailsVersion version) {
        if (version == null) {
            return null;
        }
        return new File(this.wrapperDirectory, version.version);
    }

    File getLatestWrapperImplementation() {
        File implDirectory = this.getLatestVersionDirectory();
        return this.getWrapperImplementation(this.latestVersion, implDirectory);
    }

    File getWrapperImplementation(GrailsVersion version, File implDirectory) {
        if (implDirectory == null) {
            return null;
        }
        return new File(implDirectory, "grails-cli-" + version.version + "-all.jar");
    }

    void cleanupOtherVersions(GrailsVersion toKeep) {
        File[] children = this.wrapperDirectory.listFiles();
        if (children == null) {
            return;
        }
        for (File child : children) {
            if (!child.isDirectory()) continue;
            try {
                GrailsVersion version = new GrailsVersion(child.getName());
                if (version.equals(toKeep)) {
                    continue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            child.delete();
        }
    }

    private GrailsVersion findLatestVersion() {
        if (this.versions.isEmpty()) {
            return null;
        }
        GrailsVersion lastRelease = null;
        GrailsVersion lastReleaseCandidate = null;
        GrailsVersion lastMilestone = null;
        GrailsVersion lastSnapshot = null;
        for (GrailsVersion version : this.versions) {
            if (version.releaseType == GrailsReleaseType.RELEASE && (lastRelease == null || version.compareTo(lastRelease) > 0)) {
                lastRelease = version;
                continue;
            }
            if (version.releaseType == GrailsReleaseType.RC && (lastReleaseCandidate == null || version.compareTo(lastReleaseCandidate) > 0)) {
                lastReleaseCandidate = version;
                continue;
            }
            if (version.releaseType == GrailsReleaseType.MILESTONE && (lastMilestone == null || version.compareTo(lastMilestone) > 0)) {
                lastMilestone = version;
                continue;
            }
            if (version.releaseType != GrailsReleaseType.SNAPSHOT || lastSnapshot != null && version.compareTo(lastSnapshot) <= 0) continue;
            lastSnapshot = version;
        }
        List<GrailsVersion> sortedVersions = Stream.of(lastRelease, lastReleaseCandidate, lastMilestone, lastSnapshot).filter(Objects::nonNull).sorted().toList();
        return sortedVersions.isEmpty() ? null : sortedVersions.get(sortedVersions.size() - 1);
    }

    private List<GrailsVersion> determineVersions() {
        File[] children = this.wrapperDirectory.listFiles();
        if (children == null || children.length == 0) {
            return new ArrayList<GrailsVersion>();
        }
        ArrayList<GrailsVersion> versions = new ArrayList<GrailsVersion>();
        for (File child : children) {
            if (!child.isDirectory()) continue;
            try {
                GrailsVersion version = new GrailsVersion(child.getName());
                if (!this.allowedReleaseTypes.isEmpty() && !this.allowedReleaseTypes.contains((Object)version.releaseType)) continue;
                versions.add(version);
            }
            catch (Exception ignored) {
                throw new IllegalStateException("Grails Version [" + child.getName() + "] at [" + child.getAbsolutePath() + "] is not a valid Grails version.");
            }
        }
        Collections.sort(versions);
        return versions;
    }

    public static File findGrailsHome(String grailsHomeOverride) throws IOException {
        if (grailsHomeOverride != null && !grailsHomeOverride.isEmpty()) {
            return GrailsWrapperHome.validateGrailsHome(grailsHomeOverride, "Specified Grails Home");
        }
        String environmentOverride = System.getenv("GRAILS_WRAPPER_HOME");
        if (environmentOverride != null && !environmentOverride.isEmpty()) {
            return GrailsWrapperHome.validateGrailsHome(environmentOverride, "GRAILS_WRAPPER_HOME environment variable");
        }
        File userHome = new File(System.getProperty("user.home")).getCanonicalFile();
        File grailsHome = new File(userHome, ".grails");
        if (grailsHome.exists() && !grailsHome.isDirectory()) {
            throw new IllegalStateException("Grails Wrapper Home [" + String.valueOf(grailsHome) + "] is not a directory.");
        }
        grailsHome.mkdirs();
        return grailsHome;
    }

    private static File validateGrailsHome(String possibleGrailsHome, String description) {
        File possibleHome = new File(possibleGrailsHome);
        if (!possibleHome.exists()) {
            possibleHome.mkdirs();
        }
        if (!possibleHome.isDirectory()) {
            throw new IllegalArgumentException(description + " [" + possibleGrailsHome + "] is not a directory");
        }
        return possibleHome;
    }

    private static boolean exists(File baseDirectory, String name) {
        File file = new File(baseDirectory, name);
        return file.exists();
    }

    private static boolean directoryExists(File baseDirectory, String name) {
        File file = new File(baseDirectory, name);
        return file.exists() && file.isDirectory();
    }
}

