/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.plan.actions;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.agents.api.Event;
import org.apache.flink.agents.api.context.RunnerContext;
import org.apache.flink.agents.plan.Function;
import org.apache.flink.agents.plan.serializer.ActionJsonDeserializer;
import org.apache.flink.agents.plan.serializer.ActionJsonSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;

@JsonSerialize(using=ActionJsonSerializer.class)
@JsonDeserialize(using=ActionJsonDeserializer.class)
public class Action {
    private final String name;
    private final Function exec;
    private final List<String> listenEventTypes;
    @Nullable
    private final Map<String, Object> config;

    public Action(String name, Function exec, List<String> listenEventTypes, @Nullable Map<String, Object> config) throws Exception {
        this.name = name;
        this.exec = exec;
        this.listenEventTypes = listenEventTypes;
        this.config = config;
        exec.checkSignature(new Class[]{Event.class, RunnerContext.class});
    }

    public Action(String name, Function exec, List<String> listenEventTypes) throws Exception {
        this(name, exec, listenEventTypes, null);
    }

    public String getName() {
        return this.name;
    }

    public Function getExec() {
        return this.exec;
    }

    public List<String> getListenEventTypes() {
        return this.listenEventTypes;
    }

    @Nullable
    public Map<String, Object> getConfig() {
        return this.config;
    }
}

