/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.lib.xml;

import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.util.CharacterSetRemapper;
import org.apache.daffodil.lib.xml.RemapPUACharDetected;
import scala.Char$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class RemapXMLIllegalCharToPUA
implements CharacterSetRemapper {
    private final boolean checkForExistingPUA;
    private final boolean replaceCRWithLF;

    public RemapXMLIllegalCharToPUA(boolean checkForExistingPUA, boolean replaceCRWithLF) {
        this.checkForExistingPUA = checkForExistingPUA;
        this.replaceCRWithLF = replaceCRWithLF;
    }

    @Override
    public int remap(char prev, char curr, char next) {
        char c = curr;
        int res = switch (c) {
            case '\t' -> Char$.MODULE$.char2int(curr);
            case '\n' -> Char$.MODULE$.char2int(curr);
            case '\r' -> {
                if (next == '\n') {
                    if (this.replaceCRWithLF) {
                        yield -10;
                    }
                    yield 57357;
                }
                if (this.replaceCRWithLF) {
                    yield 10;
                }
                yield 57357;
            }
            default -> {
                if (curr < ' ') {
                    yield curr + 57344;
                }
                if (Character.isSurrogate(curr)) {
                    if (Character.isHighSurrogate(curr) && Character.isLowSurrogate(next) || Character.isLowSurrogate(curr) && Character.isHighSurrogate(prev)) {
                        yield Char$.MODULE$.char2int(curr);
                    }
                    yield curr + 4096;
                }
                if (curr >= '\ue000' && curr <= '\uf8ff') {
                    if (this.checkForExistingPUA) {
                        throw new RemapPUACharDetected(curr);
                    }
                    yield Char$.MODULE$.char2int(curr);
                }
                if (curr < '\ufffe') {
                    yield Char$.MODULE$.char2int(curr);
                }
                if ('\ufffe' == c) {
                    yield 61694;
                }
                if ('\uffff' == c) {
                    yield 61695;
                }
                char bad = c;
                throw Assert$.MODULE$.impossibleCase(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Scala/Java character code cannot be beyond 0xFFFF but was 0x%40X"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)bad)})));
            }
        };
        return res;
    }
}

