/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.descriptive;

import org.apache.commons.statistics.descriptive.DoubleStatistic;
import org.apache.commons.statistics.descriptive.StatisticAccumulator;
import org.apache.commons.statistics.descriptive.Statistics;
import org.apache.commons.statistics.descriptive.SumOfCubedDeviations;

public final class Skewness
implements DoubleStatistic,
StatisticAccumulator<Skewness> {
    private static final int LENGTH_TWO = 2;
    private static final int LENGTH_THREE = 3;
    private final SumOfCubedDeviations sc;
    private boolean biased;

    private Skewness() {
        this(new SumOfCubedDeviations());
    }

    Skewness(SumOfCubedDeviations sc) {
        this.sc = sc;
    }

    public static Skewness create() {
        return new Skewness();
    }

    public static Skewness of(double ... values) {
        return new Skewness(SumOfCubedDeviations.of(values));
    }

    public static Skewness ofRange(double[] values, int from, int to) {
        Statistics.checkFromToIndex(from, to, values.length);
        return new Skewness(SumOfCubedDeviations.ofRange(values, from, to));
    }

    public static Skewness of(int ... values) {
        return new Skewness(SumOfCubedDeviations.of(values));
    }

    public static Skewness ofRange(int[] values, int from, int to) {
        Statistics.checkFromToIndex(from, to, values.length);
        return new Skewness(SumOfCubedDeviations.ofRange(values, from, to));
    }

    public static Skewness of(long ... values) {
        return new Skewness(SumOfCubedDeviations.of(values));
    }

    public static Skewness ofRange(long[] values, int from, int to) {
        Statistics.checkFromToIndex(from, to, values.length);
        return new Skewness(SumOfCubedDeviations.ofRange(values, from, to));
    }

    @Override
    public void accept(double value) {
        this.sc.accept(value);
    }

    @Override
    public double getAsDouble() {
        if (this.sc.n < (long)(this.biased ? 2 : 3)) {
            return Double.NaN;
        }
        double x2 = this.sc.getSumOfSquaredDeviations();
        if (!Double.isFinite(x2)) {
            return Double.NaN;
        }
        double x3 = this.sc.getSumOfCubedDeviations();
        if (!Double.isFinite(x3)) {
            return Double.NaN;
        }
        double m2 = x2 / (double)this.sc.n;
        if (Statistics.zeroVariance(this.sc.getFirstMoment(), m2)) {
            return Double.NaN;
        }
        double denom = Math.sqrt(m2) * m2;
        double m3 = x3 / (double)this.sc.n;
        double g1 = m3 / denom;
        if (!this.biased) {
            double n = this.sc.n;
            g1 *= Math.sqrt(n * (n - 1.0)) / (n - 2.0);
        }
        return g1;
    }

    @Override
    public Skewness combine(Skewness other) {
        this.sc.combine(other.sc);
        return this;
    }

    public Skewness setBiased(boolean v) {
        this.biased = v;
        return this;
    }
}

