/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.springrabbitmqsource;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelSpringrabbitmqsourceSourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_HOST_CONF = "camel.kamelet.spring-rabbitmq-source.host";
    public static final String CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_HOST_DOC = "RabbitMQ broker address Example: localhost";
    public static final String CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_HOST_DEFAULT = null;
    public static final String CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_PORT_CONF = "camel.kamelet.spring-rabbitmq-source.port";
    public static final String CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_PORT_DOC = "RabbitMQ broker port Example: 5672";
    public static final Integer CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_PORT_DEFAULT = null;
    public static final String CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_ROUTING_KEY_CONF = "camel.kamelet.spring-rabbitmq-source.routingKey";
    public static final String CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_ROUTING_KEY_DOC = "The routing key to use when binding a consumer queue to the exchange";
    public static final String CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_ROUTING_KEY_DEFAULT = null;
    public static final String CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_USERNAME_CONF = "camel.kamelet.spring-rabbitmq-source.username";
    public static final String CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_USERNAME_DOC = "The username to access the RabbitMQ server";
    public static final String CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_USERNAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_PASSWORD_CONF = "camel.kamelet.spring-rabbitmq-source.password";
    public static final String CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_PASSWORD_DOC = "The password to access the RabbitMQ server";
    public static final String CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_EXCHANGE_NAME_CONF = "camel.kamelet.spring-rabbitmq-source.exchangeName";
    public static final String CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_EXCHANGE_NAME_DOC = "The exchange name determines the exchange the queue is bound to.";
    public static final String CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_EXCHANGE_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_QUEUES_CONF = "camel.kamelet.spring-rabbitmq-source.queues";
    public static final String CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_QUEUES_DOC = "The queue to receive messages from";
    public static final String CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_QUEUES_DEFAULT = null;
    public static final String CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_AUTO_DECLARE_CONF = "camel.kamelet.spring-rabbitmq-source.autoDeclare";
    public static final String CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_AUTO_DECLARE_DOC = "The routing key to use when binding a consumer queue to the exchange";
    public static final Boolean CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_AUTO_DECLARE_DEFAULT = false;
    public static final String CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_VHOST_CONF = "camel.kamelet.spring-rabbitmq-source.vhost";
    public static final String CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_VHOST_DOC = "The virtual host";
    public static final String CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_VHOST_DEFAULT = "/";
    public static final String CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_PROTOCOL_CONF = "camel.kamelet.spring-rabbitmq-source.protocol";
    public static final String CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_PROTOCOL_DOC = "The AMQP protocol to use.";
    public static final String CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_PROTOCOL_DEFAULT = "amqp";

    public CamelSpringrabbitmqsourceSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelSpringrabbitmqsourceSourceConnectorConfig(
            Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_HOST_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_HOST_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_HOST_DOC);
        conf.define(CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_PORT_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_PORT_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_PORT_DOC);
        conf.define(CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_ROUTING_KEY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_ROUTING_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_ROUTING_KEY_DOC);
        conf.define(CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_USERNAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_USERNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_USERNAME_DOC);
        conf.define(CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_PASSWORD_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_PASSWORD_DOC);
        conf.define(CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_EXCHANGE_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_EXCHANGE_NAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_EXCHANGE_NAME_DOC);
        conf.define(CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_QUEUES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_QUEUES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_QUEUES_DOC);
        conf.define(CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_AUTO_DECLARE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_AUTO_DECLARE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_AUTO_DECLARE_DOC);
        conf.define(CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_VHOST_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_VHOST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_VHOST_DOC);
        conf.define(CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_PROTOCOL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_PROTOCOL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SPRINGRABBITMQSOURCE_KAMELET_PROTOCOL_DOC);
        return conf;
    }
}