/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Access AWS Athena.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface Athena2EndpointBuilderFactory {

    /**
     * Builder for endpoint for the AWS Athena component.
     */
    public interface Athena2EndpointBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedAthena2EndpointBuilder advanced() {
            return (AdvancedAthena2EndpointBuilder) this;
        }

        /**
         * The Athena database to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param database the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder database(String database) {
            doSetProperty("database", database);
            return this;
        }
        /**
         * Milliseconds before the next poll for query execution status. See the
         * section Waiting for Query Completion and Retrying Failed Queries to
         * learn more.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 2000
         * Group: producer
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll for query execution status. See the
         * section Waiting for Query Completion and Retrying Failed Queries to
         * learn more.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 2000
         * Group: producer
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder delay(String delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the first poll for query execution status. See
         * the section Waiting for Query Completion and Retrying Failed Queries
         * to learn more.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 1000
         * Group: producer
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder initialDelay(long initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll for query execution status. See
         * the section Waiting for Query Completion and Retrying Failed Queries
         * to learn more.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 1000
         * Group: producer
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder initialDelay(String initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Maximum number of times to attempt a query. Set to 1 to disable
         * retries. See the section Waiting for Query Completion and Retrying
         * Failed Queries to learn more.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 1
         * Group: producer
         * 
         * @param maxAttempts the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder maxAttempts(int maxAttempts) {
            doSetProperty("maxAttempts", maxAttempts);
            return this;
        }
        /**
         * Maximum number of times to attempt a query. Set to 1 to disable
         * retries. See the section Waiting for Query Completion and Retrying
         * Failed Queries to learn more.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 1
         * Group: producer
         * 
         * @param maxAttempts the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder maxAttempts(String maxAttempts) {
            doSetProperty("maxAttempts", maxAttempts);
            return this;
        }
        /**
         * Max number of results to return for the given operation (if supported
         * by the Athena API endpoint). If not set, will use the Athena API
         * default for the given operation.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: producer
         * 
         * @param maxResults the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder maxResults(Integer maxResults) {
            doSetProperty("maxResults", maxResults);
            return this;
        }
        /**
         * Max number of results to return for the given operation (if supported
         * by the Athena API endpoint). If not set, will use the Athena API
         * default for the given operation.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: producer
         * 
         * @param maxResults the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder maxResults(String maxResults) {
            doSetProperty("maxResults", maxResults);
            return this;
        }
        /**
         * Pagination token to use in the case where the response from the
         * previous request was truncated.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param nextToken the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder nextToken(String nextToken) {
            doSetProperty("nextToken", nextToken);
            return this;
        }
        /**
         * The Athena API function to call.
         * 
         * The option is a:
         * <code>org.apache.camel.component.aws2.athena.Athena2Operations</code>
         * type.
         * 
         * Default: startQueryExecution
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder operation(org.apache.camel.component.aws2.athena.Athena2Operations operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The Athena API function to call.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.aws2.athena.Athena2Operations</code>
         * type.
         * 
         * Default: startQueryExecution
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The location in Amazon S3 where query results are stored, such as
         * s3://path/to/query/bucket/. Ensure this value ends with a forward
         * slash.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param outputLocation the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder outputLocation(String outputLocation) {
            doSetProperty("outputLocation", outputLocation);
            return this;
        }
        /**
         * How query results should be returned. One of StreamList (default -
         * return a GetQueryResultsIterable that can page through all results),
         * SelectList (returns at most 1000 rows at a time, plus a NextToken
         * value as a header than can be used for manual pagination of results),
         * S3Pointer (return an S3 path pointing to the results).
         * 
         * The option is a:
         * <code>org.apache.camel.component.aws2.athena.Athena2OutputType</code>
         * type.
         * 
         * Default: StreamList
         * Group: producer
         * 
         * @param outputType the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder outputType(org.apache.camel.component.aws2.athena.Athena2OutputType outputType) {
            doSetProperty("outputType", outputType);
            return this;
        }
        /**
         * How query results should be returned. One of StreamList (default -
         * return a GetQueryResultsIterable that can page through all results),
         * SelectList (returns at most 1000 rows at a time, plus a NextToken
         * value as a header than can be used for manual pagination of results),
         * S3Pointer (return an S3 path pointing to the results).
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.aws2.athena.Athena2OutputType</code>
         * type.
         * 
         * Default: StreamList
         * Group: producer
         * 
         * @param outputType the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder outputType(String outputType) {
            doSetProperty("outputType", outputType);
            return this;
        }
        /**
         * The unique ID identifying the query execution.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param queryExecutionId the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder queryExecutionId(String queryExecutionId) {
            doSetProperty("queryExecutionId", queryExecutionId);
            return this;
        }
        /**
         * The SQL query to run. Except for simple queries, prefer setting this
         * as the body of the Exchange or as a header using
         * Athena2Constants.QUERY_STRING to avoid having to deal with URL
         * encoding issues.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param queryString the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder queryString(String queryString) {
            doSetProperty("queryString", queryString);
            return this;
        }
        /**
         * The region in which Athena client needs to work. When using this
         * parameter, the configuration will expect the lowercase name of the
         * region (for example ap-east-1).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param region the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder region(String region) {
            doSetProperty("region", region);
            return this;
        }
        /**
         * Reset the waitTimeout countdown in the event of a query retry. If set
         * to true, potential max time spent waiting for queries is equal to
         * waitTimeout x maxAttempts. See the section Waiting for Query
         * Completion and Retrying Failed Queries to learn more.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param resetWaitTimeoutOnRetry the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder resetWaitTimeoutOnRetry(boolean resetWaitTimeoutOnRetry) {
            doSetProperty("resetWaitTimeoutOnRetry", resetWaitTimeoutOnRetry);
            return this;
        }
        /**
         * Reset the waitTimeout countdown in the event of a query retry. If set
         * to true, potential max time spent waiting for queries is equal to
         * waitTimeout x maxAttempts. See the section Waiting for Query
         * Completion and Retrying Failed Queries to learn more.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param resetWaitTimeoutOnRetry the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder resetWaitTimeoutOnRetry(String resetWaitTimeoutOnRetry) {
            doSetProperty("resetWaitTimeoutOnRetry", resetWaitTimeoutOnRetry);
            return this;
        }
        /**
         * Optional comma separated list of error types to retry the query for.
         * Use: 'retryable' to retry all retryable failure conditions (e.g.
         * generic errors and resources exhausted), 'generic' to retry
         * 'GENERIC_INTERNAL_ERROR' failures, 'exhausted' to retry queries that
         * have exhausted resource limits, 'always' to always retry regardless
         * of failure condition, or 'never' or null to never retry (default).
         * See the section Waiting for Query Completion and Retrying Failed
         * Queries to learn more.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: never
         * Group: producer
         * 
         * @param retry the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder retry(String retry) {
            doSetProperty("retry", retry);
            return this;
        }
        /**
         * Optional max wait time in millis to wait for a successful query
         * completion. See the section Waiting for Query Completion and Retrying
         * Failed Queries to learn more.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 0
         * Group: producer
         * 
         * @param waitTimeout the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder waitTimeout(long waitTimeout) {
            doSetProperty("waitTimeout", waitTimeout);
            return this;
        }
        /**
         * Optional max wait time in millis to wait for a successful query
         * completion. See the section Waiting for Query Completion and Retrying
         * Failed Queries to learn more.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 0
         * Group: producer
         * 
         * @param waitTimeout the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder waitTimeout(String waitTimeout) {
            doSetProperty("waitTimeout", waitTimeout);
            return this;
        }
        /**
         * The workgroup to use for running the query.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param workGroup the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder workGroup(String workGroup) {
            doSetProperty("workGroup", workGroup);
            return this;
        }
        /**
         * To define a proxy host when instantiating the Athena client.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyHost the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder proxyHost(String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * To define a proxy port when instantiating the Athena client.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder proxyPort(Integer proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy port when instantiating the Athena client.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder proxyPort(String proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the Athena client.
         * 
         * The option is a: <code>software.amazon.awssdk.core.Protocol</code>
         * type.
         * 
         * Default: HTTPS
         * Group: proxy
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder proxyProtocol(software.amazon.awssdk.core.Protocol proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the Athena client.
         * 
         * The option will be converted to a
         * <code>software.amazon.awssdk.core.Protocol</code> type.
         * 
         * Default: HTTPS
         * Group: proxy
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder proxyProtocol(String proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * Amazon AWS Access Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * The encryption type to use when storing query results in S3. One of
         * SSE_S3, SSE_KMS, or CSE_KMS.
         * 
         * The option is a:
         * <code>software.amazon.awssdk.services.athena.model.EncryptionOption</code> type.
         * 
         * Group: security
         * 
         * @param encryptionOption the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder encryptionOption(software.amazon.awssdk.services.athena.model.EncryptionOption encryptionOption) {
            doSetProperty("encryptionOption", encryptionOption);
            return this;
        }
        /**
         * The encryption type to use when storing query results in S3. One of
         * SSE_S3, SSE_KMS, or CSE_KMS.
         * 
         * The option will be converted to a
         * <code>software.amazon.awssdk.services.athena.model.EncryptionOption</code> type.
         * 
         * Group: security
         * 
         * @param encryptionOption the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder encryptionOption(String encryptionOption) {
            doSetProperty("encryptionOption", encryptionOption);
            return this;
        }
        /**
         * For SSE-KMS and CSE-KMS, this is the KMS key ARN or ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param kmsKey the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder kmsKey(String kmsKey) {
            doSetProperty("kmsKey", kmsKey);
            return this;
        }
        /**
         * If using a profile credentials provider, this parameter will set the
         * profile name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param profileCredentialsName the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder profileCredentialsName(String profileCredentialsName) {
            doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }
        /**
         * Amazon AWS Secret Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param secretKey the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder secretKey(String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
        /**
         * Amazon AWS Session Token used when the user needs to assume an IAM
         * role.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param sessionToken the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder sessionToken(String sessionToken) {
            doSetProperty("sessionToken", sessionToken);
            return this;
        }
        /**
         * Set whether the Athena client should expect to load credentials
         * through a default credentials provider or to expect static
         * credentials to be passed in.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useDefaultCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }
        /**
         * Set whether the Athena client should expect to load credentials
         * through a default credentials provider or to expect static
         * credentials to be passed in.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useDefaultCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder useDefaultCredentialsProvider(String useDefaultCredentialsProvider) {
            doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }
        /**
         * Set whether the Athena client should expect to load credentials
         * through a profile credentials provider.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useProfileCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
        /**
         * Set whether the Athena client should expect to load credentials
         * through a profile credentials provider.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useProfileCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder useProfileCredentialsProvider(String useProfileCredentialsProvider) {
            doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
        /**
         * Set whether the Athena client should expect to use Session
         * Credentials. This is useful in a situation in which the user needs to
         * assume an IAM role for doing operations in Athena.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useSessionCredentials the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder useSessionCredentials(boolean useSessionCredentials) {
            doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
        /**
         * Set whether the Athena client should expect to use Session
         * Credentials. This is useful in a situation in which the user needs to
         * assume an IAM role for doing operations in Athena.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useSessionCredentials the value to set
         * @return the dsl builder
         */
        default Athena2EndpointBuilder useSessionCredentials(String useSessionCredentials) {
            doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the AWS Athena component.
     */
    public interface AdvancedAthena2EndpointBuilder
            extends
                EndpointProducerBuilder {
        default Athena2EndpointBuilder basic() {
            return (Athena2EndpointBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedAthena2EndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedAthena2EndpointBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * The AmazonAthena instance to use as the client.
         * 
         * The option is a:
         * <code>software.amazon.awssdk.services.athena.AthenaClient</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param amazonAthenaClient the value to set
         * @return the dsl builder
         */
        default AdvancedAthena2EndpointBuilder amazonAthenaClient(software.amazon.awssdk.services.athena.AthenaClient amazonAthenaClient) {
            doSetProperty("amazonAthenaClient", amazonAthenaClient);
            return this;
        }
        /**
         * The AmazonAthena instance to use as the client.
         * 
         * The option will be converted to a
         * <code>software.amazon.awssdk.services.athena.AthenaClient</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param amazonAthenaClient the value to set
         * @return the dsl builder
         */
        default AdvancedAthena2EndpointBuilder amazonAthenaClient(String amazonAthenaClient) {
            doSetProperty("amazonAthenaClient", amazonAthenaClient);
            return this;
        }
        /**
         * A unique string to ensure issues queries are idempotent. It is
         * unlikely you will need to set this.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         * 
         * @param clientRequestToken the value to set
         * @return the dsl builder
         */
        default AdvancedAthena2EndpointBuilder clientRequestToken(String clientRequestToken) {
            doSetProperty("clientRequestToken", clientRequestToken);
            return this;
        }
        /**
         * Include useful trace information at the beginning of queries as an
         * SQL comment (prefixed with --).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param includeTrace the value to set
         * @return the dsl builder
         */
        default AdvancedAthena2EndpointBuilder includeTrace(boolean includeTrace) {
            doSetProperty("includeTrace", includeTrace);
            return this;
        }
        /**
         * Include useful trace information at the beginning of queries as an
         * SQL comment (prefixed with --).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param includeTrace the value to set
         * @return the dsl builder
         */
        default AdvancedAthena2EndpointBuilder includeTrace(String includeTrace) {
            doSetProperty("includeTrace", includeTrace);
            return this;
        }
    }

    public interface Athena2Builders {
        /**
         * AWS Athena (camel-aws2-athena)
         * Access AWS Athena.
         * 
         * Category: cloud,database
         * Since: 3.4
         * Maven coordinates: org.apache.camel:camel-aws2-athena
         * 
         * @return the dsl builder for the headers' name.
         */
        default Athena2HeaderNameBuilder aws2Athena() {
            return Athena2HeaderNameBuilder.INSTANCE;
        }
        /**
         * AWS Athena (camel-aws2-athena)
         * Access AWS Athena.
         * 
         * Category: cloud,database
         * Since: 3.4
         * Maven coordinates: org.apache.camel:camel-aws2-athena
         * 
         * Syntax: <code>aws2-athena:label</code>
         * 
         * Path parameter: label (required)
         * Logical name
         * 
         * @param path label
         * @return the dsl builder
         */
        default Athena2EndpointBuilder aws2Athena(String path) {
            return Athena2EndpointBuilderFactory.endpointBuilder("aws2-athena", path);
        }
        /**
         * AWS Athena (camel-aws2-athena)
         * Access AWS Athena.
         * 
         * Category: cloud,database
         * Since: 3.4
         * Maven coordinates: org.apache.camel:camel-aws2-athena
         * 
         * Syntax: <code>aws2-athena:label</code>
         * 
         * Path parameter: label (required)
         * Logical name
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path label
         * @return the dsl builder
         */
        default Athena2EndpointBuilder aws2Athena(String componentName, String path) {
            return Athena2EndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the AWS Athena component.
     */
    public static class Athena2HeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final Athena2HeaderNameBuilder INSTANCE = new Athena2HeaderNameBuilder();

        /**
         * The operation to perform. Permitted values are getQueryExecution,
         * getQueryResults, listQueryExecutions, startQueryExecution.
         * 
         * The option is a: {@code
         * org.apache.camel.component.aws2.athena.Athena2Operations} type.
         * 
         * Default: startQueryExecution
         * Group: all
         * 
         * @return the name of the header {@code AwsAthenaOperation}.
         */
        public String awsAthenaOperation() {
            return "CamelAwsAthenaOperation";
        }
        /**
         * The Athena database to use.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: startQueryExecution
         * 
         * @return the name of the header {@code AwsAthenaDatabase}.
         */
        public String awsAthenaDatabase() {
            return "CamelAwsAthenaDatabase";
        }
        /**
         * The unique ID identifying the query execution.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: getQueryExecution getQueryResults startQueryExecution
         * 
         * @return the name of the header {@code AwsAthenaQueryExecutionId}.
         */
        public String awsAthenaQueryExecutionId() {
            return "CamelAwsAthenaQueryExecutionId";
        }
        /**
         * The workgroup to use for running the query.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: listQueryExecutions startQueryExecution
         * 
         * @return the name of the header {@code AwsAthenaWorkGroup}.
         */
        public String awsAthenaWorkGroup() {
            return "CamelAwsAthenaWorkGroup";
        }
        /**
         * Pagination token to use in the case where the response from the
         * previous request was truncated.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: getQueryResults listQueryExecutions
         * 
         * @return the name of the header {@code AwsAthenaNextToken}.
         */
        public String awsAthenaNextToken() {
            return "CamelAwsAthenaNextToken";
        }
        /**
         * Max number of results to return for the given operation (if supported
         * by the Athena API endpoint). If not set, will use the Athena API
         * default for the given operation.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: getQueryResults listQueryExecutions
         * 
         * @return the name of the header {@code AwsAthenaMaxResults}.
         */
        public String awsAthenaMaxResults() {
            return "CamelAwsAthenaMaxResults";
        }
        /**
         * Include useful trace information at the beginning of queries as an
         * SQL comment (prefixed with --).
         * 
         * The option is a: {@code boolean} type.
         * 
         * Group: startQueryExecution
         * 
         * @return the name of the header {@code AwsAthenaIncludeTrace}.
         */
        public String awsAthenaIncludeTrace() {
            return "CamelAwsAthenaIncludeTrace";
        }
        /**
         * The location in Amazon S3 where query results are stored, such as
         * s3://path/to/query/bucket/. Ensure this value ends with a forward
         * slash ('/').
         * 
         * The option is a: {@code String} type.
         * 
         * Group: getQueryExecution getQueryResults startQueryExecution
         * 
         * @return the name of the header {@code AwsAthenaOutputLocation}.
         */
        public String awsAthenaOutputLocation() {
            return "CamelAwsAthenaOutputLocation";
        }
        /**
         * How query results should be returned. One of StreamList (default -
         * return a GetQueryResultsIterable that can page through all results),
         * SelectList (returns at most 1,000 rows at a time, plus a NextToken
         * value as a header than can be used for manual pagination of results),
         * S3Pointer (return an S3 path pointing to the results).
         * 
         * The option is a: {@code
         * org.apache.camel.component.aws2.athena.Athena2OutputType} type.
         * 
         * Group: getQueryResults
         * 
         * @return the name of the header {@code AwsAthenaOutputType}.
         */
        public String awsAthenaOutputType() {
            return "CamelAwsAthenaOutputType";
        }
        /**
         * The state of the query execution.
         * 
         * The option is a: {@code
         * software.amazon.awssdk.services.athena.model.QueryExecutionState}
         * type.
         * 
         * Group: getQueryExecution getQueryResults startQueryExecution
         * 
         * @return the name of the header {@code AwsAthenaQueryExecutionState}.
         */
        public String awsAthenaQueryExecutionState() {
            return "CamelAwsAthenaQueryExecutionState";
        }
        /**
         * A unique string to ensure issues queries are idempotent. It is
         * unlikely you will need to set this.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: startQueryExecution
         * 
         * @return the name of the header {@code AwsAthenaClientRequestToken}.
         */
        public String awsAthenaClientRequestToken() {
            return "CamelAwsAthenaClientRequestToken";
        }
        /**
         * The SQL query to run. Except for simple queries, prefer setting this
         * as the body of the Exchange or as this header to avoid having to deal
         * with URL encoding issues.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: startQueryExecution
         * 
         * @return the name of the header {@code AwsAthenaQueryString}.
         */
        public String awsAthenaQueryString() {
            return "CamelAwsAthenaQueryString";
        }
        /**
         * The encryption type to use when storing query results in S3.
         * 
         * The option is a: {@code
         * software.amazon.awssdk.services.athena.model.EncryptionOption} type.
         * 
         * Group: startQueryExecution
         * 
         * @return the name of the header {@code AwsAthenaEncryptionOption}.
         */
        public String awsAthenaEncryptionOption() {
            return "CamelAwsAthenaEncryptionOption";
        }
        /**
         * For SSE-KMS and CSE-KMS, this is the KMS key ARN or ID.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: startQueryExecution
         * 
         * @return the name of the header {@code AwsAthenaKmsKey}.
         */
        public String awsAthenaKmsKey() {
            return "CamelAwsAthenaKmsKey";
        }
        /**
         * Optional max wait time in millis to wait for a successful query
         * completion. See the section 'Waiting for Query Completion and
         * Retrying Failed Queries' to learn more.
         * 
         * The option is a: {@code long} type.
         * 
         * Group: startQueryExecution
         * 
         * @return the name of the header {@code AwsAthenaWaitTimeout}.
         */
        public String awsAthenaWaitTimeout() {
            return "CamelAwsAthenaWaitTimeout";
        }
        /**
         * Milliseconds before the first poll for query execution status. See
         * the section 'Waiting for Query Completion and Retrying Failed
         * Queries' to learn more.
         * 
         * The option is a: {@code long} type.
         * 
         * Group: startQueryExecution
         * 
         * @return the name of the header {@code AwsAthenaInitialDelay}.
         */
        public String awsAthenaInitialDelay() {
            return "CamelAwsAthenaInitialDelay";
        }
        /**
         * Milliseconds before the next poll for query execution status. See the
         * section 'Waiting for Query Completion and Retrying Failed Queries' to
         * learn more.
         * 
         * The option is a: {@code long} type.
         * 
         * Group: startQueryExecution
         * 
         * @return the name of the header {@code AwsAthenaDelay}.
         */
        public String awsAthenaDelay() {
            return "CamelAwsAthenaDelay";
        }
        /**
         * Maximum number of times to attempt a query. Set to 1 to disable
         * retries. See the section 'Waiting for Query Completion and Retrying
         * Failed Queries' to learn more.
         * 
         * The option is a: {@code int} type.
         * 
         * Group: startQueryExecution
         * 
         * @return the name of the header {@code AwsAthenaMaxAttempts}.
         */
        public String awsAthenaMaxAttempts() {
            return "CamelAwsAthenaMaxAttempts";
        }
        /**
         * Optional comma separated list of error types to retry the query for.
         * Use 'retryable' to retry all retryable failure conditions (e.g.
         * generic errors and resources exhausted), 'generic' to retry
         * 'GENERIC_INTERNAL_ERROR' failures, 'exhausted' to retry queries that
         * have exhausted resource limits, 'always' to always retry regardless
         * of failure condition, or 'never' or null to never retry (default).
         * See the section 'Waiting for Query Completion and Retrying Failed
         * Queries' to learn more.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: startQueryExecution
         * 
         * @return the name of the header {@code AwsAthenaRetry}.
         */
        public String awsAthenaRetry() {
            return "CamelAwsAthenaRetry";
        }
        /**
         * Reset the waitTimeout countdown in the event of a query retry. If set
         * to true, potential max time spent waiting for queries is equal to
         * waitTimeout x maxAttempts. See the section 'Waiting for Query
         * Completion and Retrying Failed Queries' to learn more.
         * 
         * The option is a: {@code boolean} type.
         * 
         * Group: startQueryExecution
         * 
         * @return the name of the header {@code
         * AwsAthenaResetWaitTimeoutOnRetry}.
         */
        public String awsAthenaResetWaitTimeoutOnRetry() {
            return "CamelAwsAthenaResetWaitTimeoutOnRetry";
        }
        /**
         * Total number of attempts made to run the query. Will be greater than
         * 1 if the query is retried.
         * 
         * The option is a: {@code int} type.
         * 
         * Group: startQueryExecution
         * 
         * @return the name of the header {@code
         * AwsAthenaStartQueryExecutionAttempts}.
         */
        public String awsAthenaStartQueryExecutionAttempts() {
            return "CamelAwsAthenaStartQueryExecutionAttempts";
        }
        /**
         * Total time in millis taken in startQueryExecution (mostly relevant
         * when waiting for query completion within startQueryExecution).
         * 
         * The option is a: {@code long} type.
         * 
         * Group: startQueryExecution
         * 
         * @return the name of the header {@code
         * AwsAthenaStartQueryExecutionElapsedMillis}.
         */
        public String awsAthenaStartQueryExecutionElapsedMillis() {
            return "CamelAwsAthenaStartQueryExecutionElapsedMillis";
        }
    }
    static Athena2EndpointBuilder endpointBuilder(String componentName, String path) {
        class Athena2EndpointBuilderImpl extends AbstractEndpointBuilder implements Athena2EndpointBuilder, AdvancedAthena2EndpointBuilder {
            public Athena2EndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new Athena2EndpointBuilderImpl(path);
    }
}